/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.ui.text;

import com.aptana.rdt.AptanaRDTPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.CompletionProposal;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.CollectingSearchRequestor;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.core.search.SearchRequestor;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;
import org.rubypeople.rdt.internal.ti.util.OffsetNodeLocator;
import org.rubypeople.rdt.internal.ui.rubyeditor.ASTProvider;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyContentAssistInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.RubyCompletionProposalComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashKeyHeuristicProposalComputer
extends RubyCompletionProposalComputer {
    protected List<CompletionProposal> doComputeCompletionProposals(RubyContentAssistInvocationContext context, IProgressMonitor monitor) {
        return this.computeHashKeySuggestions();
    }

    private List<CompletionProposal> computeHashKeySuggestions() {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        String methodCall = this.getMethodName();
        String args = this.getArgumentsToMethodCall();
        int argIndex = this.calculateArgIndex(args);
        List<IRubyElement> methods = this.search(6, methodCall, 0, 0);
        for (IRubyElement element : methods) {
            IMethod method = (IMethod)element;
            try {
                String param;
                String[] parameters = method.getParameterNames();
                if (parameters == null || parameters.length == 0) continue;
                if (parameters.length <= argIndex) {
                    argIndex = parameters.length - 1;
                }
                if (!(param = parameters[argIndex]).endsWith(" = {}")) continue;
                RootNode ast = ASTProvider.getASTProvider().getAST((IRubyElement)method.getRubyScript(), ASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
                Node methodDefNode = OffsetNodeLocator.Instance().getNodeAtOffset((Node)ast, method.getSourceRange().getOffset());
                String variableName = param.substring(0, param.indexOf(32));
                ValidOptionVisitor visitor = new ValidOptionVisitor(variableName);
                methodDefNode.accept((NodeVisitor)visitor);
                Set<String> options = visitor.getValidOptions();
                for (String option : options) {
                    CompletionProposal proposal = new CompletionProposal(3, option, 201);
                    proposal.setName(option);
                    int start = this.fContext.getInvocationOffset();
                    proposal.setReplaceRange(start, start + option.length());
                    proposals.add(proposal);
                }
            }
            catch (RubyModelException e) {
                AptanaRDTPlugin.log((Throwable)e);
            }
        }
        return proposals;
    }

    protected List<IRubyElement> search(int type, String patternString, int limitTo, int matchRule) {
        ArrayList<IRubyElement> elements = new ArrayList<IRubyElement>();
        try {
            SearchEngine engine = new SearchEngine();
            SearchPattern pattern = SearchPattern.createPattern((int)type, (String)patternString, (int)limitTo, (int)matchRule);
            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            IRubySearchScope scope = SearchEngine.createRubySearchScope((IRubyElement[])new IRubyElement[]{this.fContext.getRubyScript().getRubyProject()});
            CollectingSearchRequestor requestor = new CollectingSearchRequestor();
            engine.search(pattern, participants, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
            List matches = requestor.getResults();
            for (SearchMatch match : matches) {
                elements.add((IRubyElement)match.getElement());
            }
        }
        catch (CoreException e) {
            AptanaRDTPlugin.log((Throwable)e);
        }
        return elements;
    }

    private String getArgumentsToMethodCall() {
        String prefix = this.getStatementPrefix();
        String methodCall = this.getMethodName();
        String args = prefix.trim().substring(methodCall.length());
        if (args.startsWith("(")) {
            args = args.substring(1);
        }
        return args;
    }

    private String getMethodName() {
        String prefix = this.getStatementPrefix();
        String methodCall = prefix.trim();
        int space = methodCall.indexOf(" ");
        if (space != -1) {
            methodCall = methodCall.substring(0, space);
        }
        if ((space = methodCall.indexOf("(")) != -1) {
            methodCall = methodCall.substring(0, space);
        }
        return methodCall;
    }

    private String getStatementPrefix() {
        try {
            return this.fContext.computeStatementPrefix().toString();
        }
        catch (BadLocationException e) {
            AptanaRDTPlugin.log((Throwable)e);
            return "";
        }
    }

    private int calculateArgIndex(String prefix) {
        String[] args = prefix.split(",");
        if (args.length == 1) {
            if (prefix.indexOf(",") == -1) {
                return 0;
            }
            return 1;
        }
        return args.length;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValidOptionVisitor
    extends InOrderVisitor {
        private Set<String> options = new HashSet<String>();
        private String variableName;
        private boolean stringify = false;

        public ValidOptionVisitor(String variableName) {
            this.variableName = variableName;
        }

        public Set<String> getValidOptions() {
            if (this.stringify) {
                HashSet<String> symbols = new HashSet<String>();
                for (String option : this.options) {
                    if (!option.startsWith("'") && !option.startsWith("\"")) continue;
                    symbols.add(":" + option.substring(1, option.length() - 5) + " => ");
                }
                return symbols;
            }
            return this.options;
        }

        public Instruction visitCallNode(CallNode iVisited) {
            Node receiver;
            String methodName = iVisited.getName();
            if (methodName.equals("[]")) {
                ArrayNode arguments;
                Node arg;
                String value;
                Node receiver2 = iVisited.getReceiverNode();
                if (ASTUtil.getNameReflectively((Node)receiver2).equals(this.variableName) && (value = ASTUtil.stringRepresentation((Node)(arg = (arguments = (ArrayNode)iVisited.getArgsNode()).get(0)))) != null) {
                    this.options.add(String.valueOf(value) + " => ");
                }
            } else if (methodName.equals("stringify_keys") && ASTUtil.getNameReflectively((Node)(receiver = iVisited.getReceiverNode())).equals(this.variableName)) {
                this.stringify = true;
            }
            return super.visitCallNode(iVisited);
        }
    }
}

