/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.ui.actions;

import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.GemListener;
import com.aptana.rdt.core.gems.IGemManager;
import com.aptana.rdt.ui.gems.GemsView;
import com.aptana.rdt.ui.gems.InstallGemDialog;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class InstallGemActionDelegate
implements IObjectActionDelegate,
IViewActionDelegate,
GemListener {
    private IAction action;
    private GemsView gemsView;
    private IGemManager gemManager;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.action = action;
    }

    public void run(IAction action) {
        InstallGemDialog dialog = new InstallGemDialog(Display.getCurrent().getActiveShell());
        if (dialog.open() == 0) {
            final Gem gem = dialog.getGem();
            final String sourceURL = dialog.getSourceURL();
            Job job = new Job(MessageFormat.format("Installing gem {0}", gem.getName())){

                public IStatus run(IProgressMonitor monitor) {
                    return InstallGemActionDelegate.this.getGemManager().installGem(gem, sourceURL, monitor);
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.action = action;
        if (this.getGemManager() != this.gemManager) {
            this.gemManager.removeGemListener((GemListener)this);
            this.getGemManager().addGemListener((GemListener)this);
            this.gemManager = this.getGemManager();
        }
        action.setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        return this.getGemManager().isRubyGemsInstalled() && this.getGemManager().isInitialized();
    }

    public void init(IViewPart view) {
        this.gemsView = (GemsView)view;
        this.gemManager = this.getGemManager();
        this.getGemManager().addGemListener((GemListener)this);
    }

    private IGemManager getGemManager() {
        return this.gemsView.getGemManager();
    }

    public void gemAdded(Gem gem) {
    }

    public void gemRemoved(Gem gem) {
    }

    public void gemsRefreshed() {
    }

    public void gemUpdated(Gem gem) {
    }

    public void managerInitialized() {
        if (this.action == null) {
            return;
        }
        this.action.setEnabled(this.isEnabled());
    }
}

