/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core.parsing;

import org.rubypeople.rdt.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.internal.debug.core.model.RubyProcessingException;
import org.rubypeople.rdt.internal.debug.core.parsing.AbstractReadStrategy;
import org.rubypeople.rdt.internal.debug.core.parsing.XmlStreamReader;
import org.rubypeople.rdt.internal.debug.core.parsing.XmlStreamReaderException;
import org.xmlpull.v1.XmlPullParser;

public class EvalReader
extends XmlStreamReader {
    private String exceptionType;
    private String exceptionMessage;
    private String name;
    private String value;

    public EvalReader(XmlPullParser xpp) {
        super(xpp);
    }

    public EvalReader(AbstractReadStrategy readStrategy) {
        super(readStrategy);
    }

    protected boolean processStartElement(XmlPullParser xpp) throws XmlStreamReaderException {
        boolean result = false;
        if (xpp.getName().equals("processingException")) {
            this.exceptionType = xpp.getAttributeValue("", "type");
            this.exceptionMessage = xpp.getAttributeValue("", "message");
            result = true;
        } else if (xpp.getName().equals("eval")) {
            this.name = xpp.getAttributeValue("", "name");
            this.value = xpp.getAttributeValue("", "value");
            result = true;
        }
        return result;
    }

    public String readEvalResult() throws RubyProcessingException {
        try {
            this.read();
        }
        catch (Exception ex) {
            RdtDebugCorePlugin.log(ex);
            return null;
        }
        if (this.exceptionType != null) {
            throw new RubyProcessingException(this.exceptionType, this.exceptionMessage);
        }
        return this.value;
    }

    public void processContent(String text) {
    }

    protected boolean processEndElement(XmlPullParser xpp) {
        return xpp.getName().equals("processingException") || xpp.getName().equals("eval");
    }
}

