/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core;

import java.io.IOException;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.rubypeople.rdt.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.debug.core.RubyLineBreakpoint;
import org.rubypeople.rdt.debug.core.model.IEvaluationResult;
import org.rubypeople.rdt.debug.core.model.IRubyExceptionBreakpoint;
import org.rubypeople.rdt.debug.core.model.IRubyStackFrame;
import org.rubypeople.rdt.internal.debug.core.ClassicDebuggerCommandFactory;
import org.rubypeople.rdt.internal.debug.core.DebuggerNotFoundException;
import org.rubypeople.rdt.internal.debug.core.ICommandFactory;
import org.rubypeople.rdt.internal.debug.core.RubyDebugCommandFactory;
import org.rubypeople.rdt.internal.debug.core.RubyExceptionBreakpoint;
import org.rubypeople.rdt.internal.debug.core.SuspensionPoint;
import org.rubypeople.rdt.internal.debug.core.commands.AbstractDebuggerConnection;
import org.rubypeople.rdt.internal.debug.core.commands.BreakpointCommand;
import org.rubypeople.rdt.internal.debug.core.commands.ClassicDebuggerConnection;
import org.rubypeople.rdt.internal.debug.core.commands.GenericCommand;
import org.rubypeople.rdt.internal.debug.core.commands.RubyDebugConnection;
import org.rubypeople.rdt.internal.debug.core.model.IRubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyEvaluationResult;
import org.rubypeople.rdt.internal.debug.core.model.RubyProcessingException;
import org.rubypeople.rdt.internal.debug.core.model.RubyStackFrame;
import org.rubypeople.rdt.internal.debug.core.model.RubyThread;
import org.rubypeople.rdt.internal.debug.core.model.RubyVariable;
import org.rubypeople.rdt.internal.debug.core.model.ThreadInfo;
import org.rubypeople.rdt.internal.debug.core.parsing.AbstractReadStrategy;
import org.rubypeople.rdt.internal.debug.core.parsing.ErrorReader;
import org.rubypeople.rdt.internal.debug.core.parsing.FramesReader;
import org.rubypeople.rdt.internal.debug.core.parsing.LoadResultReader;
import org.rubypeople.rdt.internal.debug.core.parsing.SuspensionReader;
import org.rubypeople.rdt.internal.debug.core.parsing.ThreadInfoReader;
import org.rubypeople.rdt.internal.debug.core.parsing.VariableReader;

public class RubyDebuggerProxy {
    public static final String DEBUGGER_ACTIVE_KEY = "org.rubypeople.rdt.debug.ui.debuggerActive";
    private AbstractDebuggerConnection debuggerConnection;
    private IRubyDebugTarget debugTarget;
    private RubyLoop rubyLoop;
    private ICommandFactory commandFactory;
    private Thread threadUpdater;
    private Thread errorReader;
    private boolean isLoopFinished;

    public RubyDebuggerProxy(IRubyDebugTarget debugTarget, boolean isRubyDebug) {
        this.debugTarget = debugTarget;
        debugTarget.setRubyDebuggerProxy(this);
        this.commandFactory = isRubyDebug ? new RubyDebugCommandFactory() : new ClassicDebuggerCommandFactory();
        this.debuggerConnection = isRubyDebug ? new RubyDebugConnection(debugTarget.getHost(), debugTarget.getPort()) : new ClassicDebuggerConnection(debugTarget.getPort());
    }

    public boolean checkConnection() {
        return this.debuggerConnection.isCommandPortConnected();
    }

    public void start() throws RubyProcessingException, IOException {
        this.isLoopFinished = false;
        this.debuggerConnection.connect();
        this.setBreakPoints();
        this.startRubyLoop();
    }

    public void stop() throws IOException {
        if (this.rubyLoop == null) {
            return;
        }
        this.rubyLoop.setShouldStop();
        this.rubyLoop.interrupt();
        this.closeConnection();
    }

    protected void setBreakPoints() throws IOException {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.rubypeople.rdt.debug");
        int i = 0;
        while (i < breakpoints.length) {
            this.addBreakpoint(breakpoints[i]);
            ++i;
        }
    }

    public void addBreakpoint(IBreakpoint breakpoint) {
        try {
            if (breakpoint.isEnabled()) {
                if (breakpoint instanceof IRubyExceptionBreakpoint) {
                    String command = this.commandFactory.createCatchOn((IRubyExceptionBreakpoint)breakpoint);
                    new BreakpointCommand(command).execute(this.debuggerConnection);
                } else if (breakpoint instanceof RubyLineBreakpoint) {
                    RubyLineBreakpoint rubyLineBreakpoint = (RubyLineBreakpoint)breakpoint;
                    String command = this.commandFactory.createAddBreakpoint(rubyLineBreakpoint.getFileName(), rubyLineBreakpoint.getLineNumber());
                    int index = new BreakpointCommand(command).executeWithResult(this.debuggerConnection);
                    rubyLineBreakpoint.setIndex(index);
                }
            }
        }
        catch (IOException e) {
            RdtDebugCorePlugin.log(e);
        }
        catch (CoreException e) {
            RdtDebugCorePlugin.log(e);
        }
    }

    public void removeBreakpoint(IBreakpoint breakpoint) {
        try {
            RubyLineBreakpoint rubyLineBreakpoint;
            if (breakpoint instanceof RubyExceptionBreakpoint) {
                String command = this.commandFactory.createCatchOff((IRubyExceptionBreakpoint)breakpoint);
                if (command != null) {
                    new BreakpointCommand(command).execute(this.debuggerConnection);
                }
            } else if (breakpoint instanceof RubyLineBreakpoint && (rubyLineBreakpoint = (RubyLineBreakpoint)breakpoint).getIndex() != -1) {
                String command = this.commandFactory.createRemoveBreakpoint(rubyLineBreakpoint.getIndex());
                new BreakpointCommand(command).executeWithResult(this.debuggerConnection);
                rubyLineBreakpoint.setIndex(-1);
            }
        }
        catch (IOException e) {
            RdtDebugCorePlugin.log(e);
        }
    }

    public void updateBreakpoint(IBreakpoint breakpoint, IMarkerDelta markerDelta) {
        this.removeBreakpoint(breakpoint);
        this.addBreakpoint(breakpoint);
    }

    public void startRubyLoop() throws DebuggerNotFoundException, IOException {
        this.debuggerConnection.start();
        this.rubyLoop = new RubyLoop();
        this.rubyLoop.start();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    try {
                        RdtDebugCorePlugin.debug("Command Connection error handler started.");
                        while (RubyDebuggerProxy.this.debuggerConnection.getCommandReadStrategy().isConnected()) {
                            new ErrorReader(RubyDebuggerProxy.this.debuggerConnection.getCommandReadStrategy()).read();
                        }
                    }
                    catch (Exception e) {
                        RdtDebugCorePlugin.log(e);
                        RdtDebugCorePlugin.debug("Command Connection error handler finished.");
                    }
                }
                finally {
                    RdtDebugCorePlugin.debug("Command Connection error handler finished.");
                }
            }
        };
        this.errorReader = new Thread(runnable, "Error Reader");
        this.errorReader.start();
        Runnable threadListener = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        RdtDebugCorePlugin.debug("Thread updater started.");
                        Thread.sleep(2000L);
                        GenericCommand cmd = null;
                        while (true) {
                            if (cmd != null) {
                                if (cmd == null) return;
                                if (!cmd.getReadStrategy().isConnected()) {
                                    return;
                                }
                            }
                            if (!RubyDebuggerProxy.this.getDebugTarget().isSuspended()) {
                                String command = RubyDebuggerProxy.this.commandFactory.createReadThreads();
                                cmd = new GenericCommand(command, true);
                                cmd.execute(RubyDebuggerProxy.this.debuggerConnection);
                                ThreadInfo[] threadInfos = new ThreadInfoReader(cmd.getReadStrategy()).readThreads();
                                ((RubyDebugTarget)RubyDebuggerProxy.this.getDebugTarget()).updateThreads(threadInfos);
                            }
                            Thread.sleep(2000L);
                        }
                    }
                    catch (Exception e) {
                        RdtDebugCorePlugin.log(e);
                        RdtDebugCorePlugin.debug("Thread updater finished.");
                        return;
                    }
                }
                finally {
                    RdtDebugCorePlugin.debug("Thread updater finished.");
                }
            }
        };
        this.threadUpdater = new Thread(threadListener, "Ruby Thread Updater");
        this.threadUpdater.start();
    }

    public void resume(RubyThread thread) {
        try {
            this.println(this.commandFactory.createResume(thread));
        }
        catch (IOException iOException) {}
    }

    protected void println(String s) throws IOException {
        try {
            new GenericCommand(s, false).execute(this.debuggerConnection);
        }
        catch (IOException e) {
            RdtDebugCorePlugin.debug("Could not send to debugger. Exception occured.", e);
            throw e;
        }
    }

    protected IRubyDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    public RubyVariable[] readVariables(RubyStackFrame frame) throws DebugException {
        try {
            this.println(this.commandFactory.createReadLocalVariables(frame));
            return new VariableReader(this.getMultiReaderStrategy()).readVariables(frame);
        }
        catch (Exception e) {
            throw new DebugException((IStatus)new Status(4, RdtDebugCorePlugin.getPluginIdentifier(), -1, e.getMessage(), (Throwable)e));
        }
    }

    public RubyVariable[] readInstanceVariables(RubyVariable variable) {
        try {
            this.println(this.commandFactory.createReadInstanceVariable(variable));
            return new VariableReader(this.getMultiReaderStrategy()).readVariables(variable);
        }
        catch (Exception ioex) {
            ioex.printStackTrace();
            throw new RuntimeException(ioex.getMessage());
        }
    }

    public RubyVariable readInspectExpression(IRubyStackFrame frame, String expression) throws RubyProcessingException {
        RubyVariable[] variables;
        RubyEvaluationResult result;
        block3: {
            try {
                expression = expression.replaceAll("\\n", "\\\\n");
                result = new RubyEvaluationResult(expression, frame.getThread());
                this.println(this.commandFactory.createInspect(frame, expression));
                variables = new VariableReader(this.getMultiReaderStrategy()).readVariables(frame);
                if (variables.length != 0) break block3;
                return null;
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
                throw new RuntimeException(ioex.getMessage());
            }
        }
        result.setValue(variables[0].getValue());
        return variables[0];
    }

    public IEvaluationResult evaluate(RubyStackFrame frame, String expression) {
        expression = expression.replaceAll("\\r\\n", "\n");
        expression = expression.replaceAll("\\n", "; ");
        expression = expression.trim();
        RubyEvaluationResult result = new RubyEvaluationResult(expression, frame.getThread());
        try {
            this.println(this.commandFactory.createInspect(frame, expression));
            RubyVariable[] variables = new VariableReader(this.getMultiReaderStrategy()).readVariables(frame);
            if (variables.length > 0) {
                result.setValue(variables[0].getValue());
            }
        }
        catch (IOException ioex) {
            DebugException ex = new DebugException((IStatus)new Status(4, "org.rubypeople.rdt.debug.core", 5013, ioex.getMessage(), (Throwable)ioex));
            result.setException(ex);
        }
        catch (RubyProcessingException e) {
            DebugException ex = new DebugException((IStatus)new Status(4, "org.rubypeople.rdt.debug.core", 5010, e.getMessage(), (Throwable)e));
            result.setException(ex);
        }
        return result;
    }

    public void sendStepOverEnd(RubyStackFrame stackFrame) {
        try {
            this.println(this.commandFactory.createStepOver(stackFrame));
        }
        catch (Exception e) {
            RdtDebugCorePlugin.log(e);
        }
    }

    public void sendStepReturnEnd(RubyStackFrame stackFrame) {
        try {
            this.println(this.commandFactory.createStepReturn(stackFrame));
        }
        catch (Exception e) {
            RdtDebugCorePlugin.log(e);
        }
    }

    public void sendStepIntoEnd(RubyStackFrame stackFrame) {
        try {
            this.println(this.commandFactory.createStepInto(stackFrame));
        }
        catch (Exception e) {
            RdtDebugCorePlugin.log(e);
        }
    }

    public void sendThreadStop(RubyThread thread) {
        try {
            String command = this.commandFactory.createThreadStop(thread);
            new GenericCommand(command, true).execute(this.debuggerConnection);
        }
        catch (Exception e) {
            RdtDebugCorePlugin.log(e);
        }
    }

    public RubyStackFrame[] readFrames(RubyThread thread) {
        try {
            this.println(this.commandFactory.createReadFrames(thread));
            return new FramesReader(this.getMultiReaderStrategy()).readFrames(thread);
        }
        catch (IOException e) {
            RdtDebugCorePlugin.log(e);
            return null;
        }
    }

    public ThreadInfo[] readThreads() {
        try {
            String command = this.commandFactory.createReadThreads();
            new GenericCommand(command, true).execute(this.debuggerConnection);
            return new ThreadInfoReader(this.getMultiReaderStrategy()).readThreads();
        }
        catch (Exception e) {
            RdtDebugCorePlugin.log(e);
            return null;
        }
    }

    public IStatus readLoadResult(String filename) {
        try {
            this.println(this.commandFactory.createLoad(filename));
            return new LoadResultReader(this.getMultiReaderStrategy()).readLoadResult();
        }
        catch (Exception e) {
            return new Status(4, RdtDebugCorePlugin.getPluginIdentifier(), -1, e.getMessage(), (Throwable)e);
        }
    }

    public void closeConnection() throws IOException {
        this.debuggerConnection.exit();
    }

    private AbstractReadStrategy getMultiReaderStrategy() {
        return this.debuggerConnection.getCommandReadStrategy();
    }

    class RubyLoop
    extends Thread {
        public RubyLoop() {
            this.setName("RubyDebuggerLoop");
        }

        public void setShouldStop() {
        }

        public void run() {
            try {
                try {
                    SuspensionPoint hit;
                    System.setProperty(RubyDebuggerProxy.DEBUGGER_ACTIVE_KEY, "true");
                    RdtDebugCorePlugin.debug("Waiting for breakpoints.");
                    while ((hit = new SuspensionReader(RubyDebuggerProxy.this.getMultiReaderStrategy()).readSuspension()) != null) {
                        RdtDebugCorePlugin.debug(hit);
                        new Thread(){

                            public void run() {
                                RubyDebuggerProxy.this.getDebugTarget().suspensionOccurred(hit);
                            }
                        }.start();
                    }
                }
                catch (DebuggerNotFoundException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    RdtDebugCorePlugin.debug("Exception in socket reader loop.", ex);
                    System.setProperty(RubyDebuggerProxy.DEBUGGER_ACTIVE_KEY, "false");
                    try {
                        RubyDebuggerProxy.this.getDebugTarget().terminate();
                        RubyDebuggerProxy.this.closeConnection();
                    }
                    catch (Exception e) {
                        RdtDebugCorePlugin.log(e);
                    }
                    RdtDebugCorePlugin.debug("Socket reader loop finished.");
                }
            }
            finally {
                System.setProperty(RubyDebuggerProxy.DEBUGGER_ACTIVE_KEY, "false");
                try {
                    RubyDebuggerProxy.this.getDebugTarget().terminate();
                    RubyDebuggerProxy.this.closeConnection();
                }
                catch (Exception e) {
                    RdtDebugCorePlugin.log(e);
                }
                RdtDebugCorePlugin.debug("Socket reader loop finished.");
            }
        }
    }
}

