/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.debug.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.LineBreakpoint;

public class RubyLineBreakpoint
extends LineBreakpoint {
    public static final String RUBY_BREAKPOINT_MARKER = "org.rubypeople.rdt.debug.core.rubyLineBreakpointMarker";
    private static final String EXTERNAL_FILENAME = "externalFileName";
    private int index = -1;

    public RubyLineBreakpoint() {
    }

    public RubyLineBreakpoint(IResource resource, int lineNumber) throws CoreException {
        this(resource, lineNumber, resource.getName());
    }

    public RubyLineBreakpoint(final IResource resource, final int lineNumber, final String fileName) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                RubyLineBreakpoint.this.setMarker(resource.createMarker(RubyLineBreakpoint.RUBY_BREAKPOINT_MARKER));
                RubyLineBreakpoint.this.getMarker().setAttribute("lineNumber", lineNumber + 1);
                RubyLineBreakpoint.this.getMarker().setAttribute("org.eclipse.debug.core.id", (Object)RubyLineBreakpoint.this.getModelIdentifier());
                RubyLineBreakpoint.this.getMarker().setAttribute("org.eclipse.debug.core.registered", false);
                RubyLineBreakpoint.this.getMarker().setAttribute(RubyLineBreakpoint.EXTERNAL_FILENAME, (Object)fileName);
                RubyLineBreakpoint.this.setEnabled(true);
                RubyLineBreakpoint.this.setRegistered(true);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    public String getFileName() throws CoreException {
        IResource resource = this.ensureMarker().getResource();
        if (resource.equals((Object)ResourcesPlugin.getWorkspace().getRoot())) {
            return this.ensureMarker().getAttribute(EXTERNAL_FILENAME, "");
        }
        return resource.getName();
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public static String getMarkerType() {
        return RUBY_BREAKPOINT_MARKER;
    }

    public String getModelIdentifier() {
        return "org.rubypeople.rdt.debug";
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

