/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.radrails.rails.internal.ui.text.correction.LocalCorrectionsSubProcessor;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.ui.text.ruby.IInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.IProblemLocation;
import org.rubypeople.rdt.ui.text.ruby.IQuickFixProcessor;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickFixProcessor
implements IQuickFixProcessor {
    public IRubyCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0) {
            return null;
        }
        HashSet<Integer> handledProblems = new HashSet<Integer>(locations.length);
        ArrayList<IRubyCompletionProposal> resultingCollections = new ArrayList<IRubyCompletionProposal>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            Integer id = new Integer(curr.getProblemId());
            if (handledProblems.add(id)) {
                this.process(context, curr, resultingCollections);
            }
            ++i;
        }
        return resultingCollections.toArray(new IRubyCompletionProposal[resultingCollections.size()]);
    }

    private void process(IInvocationContext context, IProblemLocation problem, Collection<IRubyCompletionProposal> proposals) throws CoreException {
        int id = problem.getProblemId();
        if (id == 0) {
            return;
        }
        switch (id) {
            case 519: {
                IRubyScript script = context.getRubyScript();
                String src = script.getSource();
                String name = src.substring(problem.getOffset(), problem.getOffset() + problem.getLength());
                String fixed = name.substring(1);
                LocalCorrectionsSubProcessor.addReplacementProposal(fixed, "Convert from " + name + " to " + fixed, problem, proposals);
                break;
            }
            case 518: {
                LocalCorrectionsSubProcessor.addReplacementProposal(problem.getOffset(), "human_size".length(), "number_to_human_size", "Convert from human_size to number_to_human_size", proposals);
                break;
            }
            case 513: {
                this.fixOldRenderCall(context, problem, proposals);
                break;
            }
        }
    }

    private void fixOldRenderCall(IInvocationContext context, IProblemLocation problem, Collection<IRubyCompletionProposal> proposals) throws RubyModelException {
        IRubyScript script = context.getRubyScript();
        String src = script.getSource();
        String name = src.substring(problem.getOffset(), problem.getOffset() + problem.getLength()).trim();
        int index = name.indexOf(" ");
        if (index == -1) {
            index = name.indexOf("(");
        }
        if (index != -1) {
            name = name.substring(0, index);
        }
        String[] possible = new String[]{"render_text", "render_file", "render_template", "render_partial", "render_action"};
        int i = 0;
        while (i < possible.length) {
            String[] parts;
            if (name.equals(possible[i]) && (parts = name.split("_")) != null && parts.length >= 2) {
                String fixed = "render :" + parts[1] + " =>";
                LocalCorrectionsSubProcessor.addReplacementProposal(problem.getOffset(), possible[i].length(), fixed, "Convert from " + possible[i] + " to " + fixed, proposals);
                return;
            }
            ++i;
        }
    }

    public boolean hasCorrections(IRubyScript unit, int problemId) {
        switch (problemId) {
            case 513: 
            case 518: 
            case 519: {
                return true;
            }
        }
        return false;
    }
}

