/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.text;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.jruby.ast.RootNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.SyntaxException;
import org.radrails.rails.core.Inflector;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.text.ActiveRecordAssociationsVisitor;
import org.radrails.rails.internal.ui.text.MigrationVisitor;
import org.radrails.rails.internal.ui.text.PsuedoMethod;
import org.radrails.rails.ui.RailsUILog;
import org.radrails.rails.ui.text.RailsHeuristicCompletionComputer;
import org.rubypeople.rdt.core.CompletionProposal;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.CollectingSearchRequestor;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.core.search.SearchRequestor;
import org.rubypeople.rdt.internal.codeassist.CompletionContext;
import org.rubypeople.rdt.internal.codeassist.RubyElementRequestor;
import org.rubypeople.rdt.internal.core.LogicalType;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.ti.ITypeGuess;
import org.rubypeople.rdt.internal.ti.ITypeInferrer;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.ASTProvider;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyCompletionProposal;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyContentAssistInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.CompletionProposalCollector;
import org.rubypeople.rdt.ui.text.ruby.ContentAssistInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposalComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsCompletionProposalComputer
implements IRubyCompletionProposalComputer {
    private ContentAssistInvocationContext fContext;
    private static final String[] TableNameFirstArgs = new String[]{"rename_column", "drop_table", "remove_column", "remove_index", "add_column", "add_index", "change_column", "create_table"};
    private static final String[] ColumnNameSecondArgs = new String[]{"rename_column", "remove_column", "add_index", "change_column"};

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        this.fContext = context;
        ArrayList<Object> list = new ArrayList<Object>();
        Map<String, File> completions = RailsHeuristicCompletionComputer.getControllerCompletions(this.getControllersFolder(context), context.getDocument(), context.getInvocationOffset());
        completions.putAll(RailsHeuristicCompletionComputer.getActionCompletions(this.getControllersFolder(context), context.getDocument(), context.getInvocationOffset()));
        for (String replacement : completions.keySet()) {
            RubyCompletionProposal prop = new RubyCompletionProposal(replacement, context.getInvocationOffset(), 0, null, replacement, 10000);
            list.add(prop);
        }
        if (context instanceof RubyContentAssistInvocationContext) {
            RubyContentAssistInvocationContext rubyContext = (RubyContentAssistInvocationContext)context;
            IType type = this.getInferredActiveRecord(rubyContext);
            if (type != null) {
                list.addAll(this.addActiveRecordFieldMethods(type, rubyContext));
                list.addAll(this.addActiveRecordAssociations(type, rubyContext));
            }
            list.addAll(this.addMigrationMethods(rubyContext));
            list.addAll(this.addMigrationMethodArgumentSuggestions(rubyContext));
        }
        this.fContext = null;
        return list;
    }

    private String getArgumentsToMethodCall() {
        String prefix = this.getStatementPrefix();
        String methodCall = this.getMethodName();
        String args = prefix.trim().substring(methodCall.length());
        if (args.startsWith("(")) {
            args = args.substring(1);
        }
        return args;
    }

    private String getMethodName() {
        String prefix = this.getStatementPrefix();
        String methodCall = prefix.trim();
        int space = methodCall.indexOf(" ");
        if (space != -1) {
            methodCall = methodCall.substring(0, space);
        }
        if ((space = methodCall.indexOf("(")) != -1) {
            methodCall = methodCall.substring(0, space);
        }
        return methodCall;
    }

    private Collection<? extends ICompletionProposal> addMigrationMethodArgumentSuggestions(RubyContentAssistInvocationContext context) {
        IRubyScript script = this.getScript(context);
        if (!this.isDBMigration(script)) {
            return Collections.emptyList();
        }
        CompletionProposalCollector completion = this.createCollector(context);
        String methodName = this.getMethodName();
        String args = this.getArgumentsToMethodCall();
        int argumentIndex = this.calculateArgIndex(args);
        if (this.contains(methodName, TableNameFirstArgs) && argumentIndex == 0) {
            Set<String> tableNames = this.getDBTableNames(script);
            for (String tableName : tableNames) {
                if (!tableName.startsWith(":")) {
                    tableName = ":" + tableName;
                }
                if (tableName.equals(":table_name")) continue;
                CompletionProposal proposal = new CompletionProposal(3, tableName, 201);
                proposal.setName(tableName);
                int start = context.getInvocationOffset();
                proposal.setReplaceRange(start, start + tableName.length());
                completion.accept(proposal);
            }
        }
        if (this.contains(methodName, ColumnNameSecondArgs) && argumentIndex == 1) {
            String tableName = this.getArgAt(0, args).trim().substring(1);
            Set<String> fieldNames = this.getDBFieldNames(script, Inflector.singularize((String)tableName));
            for (String fieldName : fieldNames) {
                fieldName = "'" + fieldName + "'";
                CompletionProposal proposal = new CompletionProposal(3, fieldName, 201);
                proposal.setName(fieldName);
                int start = context.getInvocationOffset();
                proposal.setReplaceRange(start, start + fieldName.length());
                completion.accept(proposal);
            }
        }
        return Arrays.asList(completion.getRubyCompletionProposals());
    }

    private boolean contains(String methodName, String[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(methodName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getArgAt(int i, String argsRaw) {
        String[] args = argsRaw.split(",");
        return args[i];
    }

    private int calculateArgIndex(String prefix) {
        String[] args = prefix.split(",");
        if (args.length == 1) {
            if (prefix.indexOf(",") == -1) {
                return 0;
            }
            return 1;
        }
        return args.length;
    }

    private Collection<? extends ICompletionProposal> addActiveRecordAssociations(IType type, RubyContentAssistInvocationContext context) {
        if (type == null) {
            return Collections.emptyList();
        }
        IRubyScript script = type.getRubyScript();
        RootNode ast = ASTProvider.getASTProvider().getAST((IRubyElement)script, ASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
        if (ast == null) {
            return Collections.emptyList();
        }
        ActiveRecordAssociationsVisitor visitor = new ActiveRecordAssociationsVisitor();
        ast.accept((NodeVisitor)visitor);
        List<IMethod> fields = visitor.getMethods();
        CompletionProposalCollector collector = this.createCollector(context);
        for (IMethod method : fields) {
            collector.accept(this.createProposal((ContentAssistInvocationContext)context, type.getElementName(), method));
        }
        return Arrays.asList(collector.getRubyCompletionProposals());
    }

    protected CompletionProposalCollector createCollector(RubyContentAssistInvocationContext context) {
        return new CompletionProposalCollector(context);
    }

    private Collection<? extends ICompletionProposal> addMigrationMethods(RubyContentAssistInvocationContext context) {
        if (this.getStatementPrefix().trim().length() > 0) {
            return Collections.emptyList();
        }
        IRubyScript script = this.getScript(context);
        if (!this.isDBMigration(script)) {
            return Collections.emptyList();
        }
        CompletionProposalCollector completion = this.createCollector(context);
        String typeName = "ActiveRecord::ConnectionAdapters::SchemaStatements";
        List<IType> types = this.findTypeDeclarations(typeName, script);
        try {
            for (IType type : types) {
                IMethod[] methods = type.getMethods();
                int i = 0;
                while (i < methods.length) {
                    IMethod method = methods[i];
                    if (method != null && method.isPublic()) {
                        completion.accept(this.createProposal((ContentAssistInvocationContext)context, typeName, method));
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            RailsUILog.log((CoreException)e);
        }
        return Arrays.asList(completion.getRubyCompletionProposals());
    }

    private boolean isDBMigration(IRubyScript script) {
        IPath path = script.getPath();
        return this.getMigrationPath(script).isPrefixOf(path);
    }

    private IPath getMigrationPath(IRubyScript script) {
        IPath railsRoot = RailsPlugin.findRailsRoot((IProject)script.getRubyProject().getProject());
        return script.getRubyProject().getPath().append(railsRoot).append("db").append("migrate");
    }

    private List<IType> findTypeDeclarations(String typeName, IRubyScript script) {
        ArrayList<IType> types = new ArrayList<IType>();
        try {
            SearchEngine engine = new SearchEngine();
            SearchPattern pattern = SearchPattern.createPattern((int)5, (String)typeName, (int)0, (int)0);
            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            IRubySearchScope scope = SearchEngine.createRubySearchScope((IRubyElement[])new IRubyElement[]{script.getRubyProject()});
            CollectingSearchRequestor requestor = new CollectingSearchRequestor();
            engine.search(pattern, participants, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
            List matches = requestor.getResults();
            for (SearchMatch match : matches) {
                IType type = (IType)match.getElement();
                types.add(type);
            }
        }
        catch (CoreException e) {
            RailsUILog.log((CoreException)e);
        }
        return types;
    }

    private CompletionProposal createProposal(ContentAssistInvocationContext context, String typeName, IMethod method) {
        String methodName = method.getElementName();
        CharSequence prefix = "";
        try {
            prefix = context.computeIdentifierPrefix();
        }
        catch (BadLocationException e) {
            RailsUILog.log((Exception)((Object)e));
        }
        if (!methodName.startsWith(prefix.toString())) {
            return null;
        }
        CompletionProposal proposal = new CompletionProposal(6, methodName, 101);
        proposal.setDeclaringType(typeName);
        proposal.setElement((IRubyElement)method);
        proposal.setName(methodName);
        int flags = 1;
        if (method.isSingleton()) {
            flags |= 8;
        }
        proposal.setFlags(flags);
        int start = context.getInvocationOffset() - prefix.length();
        proposal.setReplaceRange(start, start + methodName.length());
        return proposal;
    }

    private List<IType> inferType(RubyContentAssistInvocationContext context) {
        ArrayList<IType> inferred = new ArrayList<IType>();
        IRubyScript script = this.getScript(context);
        if (script == null) {
            return inferred;
        }
        try {
            CompletionContext myContext = new CompletionContext(script, context.getInvocationOffset() - 1);
            Collection guesses = this.getTypeInferrer().infer(myContext.getCorrectedSource(), myContext.getOffset());
            if (guesses == null) {
                return inferred;
            }
            RubyElementRequestor requestor = new RubyElementRequestor(script);
            for (ITypeGuess guess : guesses) {
                IType[] types = requestor.findType(guess.getType());
                if (types == null || types.length <= 0) continue;
                inferred.add((IType)new LogicalType(types));
            }
        }
        catch (RubyModelException e) {
            RailsUILog.log((CoreException)((Object)e));
        }
        return inferred;
    }

    protected ITypeInferrer getTypeInferrer() {
        return RubyCore.getTypeInferrer();
    }

    private IType getInferredActiveRecord(RubyContentAssistInvocationContext context) {
        List<IType> types = this.inferType(context);
        for (IType type : types) {
            try {
                if (!"ActiveRecord::Base".equals(type.getSuperclassName())) continue;
                return type;
            }
            catch (RubyModelException e) {
                RailsUILog.log((CoreException)((Object)e));
            }
        }
        return null;
    }

    private List<IRubyCompletionProposal> addActiveRecordFieldMethods(IType type, RubyContentAssistInvocationContext context) {
        if (type == null) {
            return Collections.EMPTY_LIST;
        }
        CompletionProposalCollector collector = this.createCollector(context);
        Set<String> fieldNames = this.getDBFieldNames(this.getScript(context), type.getElementName());
        for (String fieldName : fieldNames) {
            collector.accept(this.createProposal((ContentAssistInvocationContext)context, type.getElementName(), new PsuedoMethod(fieldName, null, 1)));
            collector.accept(this.createProposal((ContentAssistInvocationContext)context, type.getElementName(), new PsuedoMethod(String.valueOf(fieldName) + "=", new String[]{fieldName}, 1)));
            collector.accept(this.createProposal((ContentAssistInvocationContext)context, type.getElementName(), new PsuedoMethod("find_by_" + fieldName, new String[]{fieldName}, 9)));
            collector.accept(this.createProposal((ContentAssistInvocationContext)context, type.getElementName(), new PsuedoMethod("find_all_by_" + fieldName, new String[]{fieldName}, 9)));
        }
        return Arrays.asList(collector.getRubyCompletionProposals());
    }

    private IRubyScript getScript(RubyContentAssistInvocationContext context) {
        return context.getRubyScript();
    }

    private Set<String> getDBFieldNames(IRubyScript script, String modelName) {
        HashSet<String> fieldNames = new HashSet<String>();
        File[] scripts = this.getMigrationScripts(script);
        int j = 0;
        while (j < scripts.length) {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(scripts[j].getAbsolutePath()));
            IRubyScript migrateScript = RubyCore.create((IFile)iFile);
            RootNode ast = null;
            if (migrateScript.isWorkingCopy()) {
                try {
                    String prefix = this.getStatementPrefix();
                    int fudgeFactor = 1;
                    while (prefix.endsWith(" ")) {
                        ++fudgeFactor;
                        prefix = prefix.substring(0, prefix.length() - 1);
                    }
                    CompletionContext correctingContext = new CompletionContext(migrateScript, this.fContext.getInvocationOffset() - fudgeFactor);
                    if (correctingContext.isBroken()) {
                        try {
                            RubyParser parser = new RubyParser();
                            ast = (RootNode)parser.parse(correctingContext.getCorrectedSource()).getAST();
                        }
                        catch (SyntaxException syntaxException) {}
                    }
                }
                catch (RubyModelException e) {
                    RailsUILog.log((CoreException)((Object)e));
                }
            }
            if (ast == null && (ast = RubyPlugin.getDefault().getASTProvider().getAST((IRubyElement)migrateScript, ASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor())) == null) {
                ast = (RootNode)((RubyScript)migrateScript).lastGoodAST;
            }
            if (ast != null) {
                MigrationVisitor visitor = new MigrationVisitor();
                ast.accept((NodeVisitor)visitor);
                fieldNames.addAll(visitor.getFieldNames(Inflector.pluralize((String)modelName)));
            }
            ++j;
        }
        return fieldNames;
    }

    private String getStatementPrefix() {
        try {
            return this.fContext.computeStatementPrefix().toString();
        }
        catch (BadLocationException e) {
            RailsUILog.log((Exception)((Object)e));
            return "";
        }
    }

    private Set<String> getDBTableNames(IRubyScript script) {
        HashSet<String> fieldNames = new HashSet<String>();
        File[] scripts = this.getMigrationScripts(script);
        int j = 0;
        while (j < scripts.length) {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(scripts[j].getAbsolutePath()));
            IRubyScript migrateScript = RubyCore.create((IFile)iFile);
            RootNode ast = RubyPlugin.getDefault().getASTProvider().getAST((IRubyElement)migrateScript, ASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
            if (ast == null) {
                ast = (RootNode)((RubyScript)migrateScript).lastGoodAST;
            }
            if (ast != null) {
                MigrationVisitor visitor = new MigrationVisitor();
                ast.accept((NodeVisitor)visitor);
                fieldNames.addAll(visitor.getTableNames());
            }
            ++j;
        }
        return fieldNames;
    }

    private File[] getMigrationScripts(IRubyScript script) {
        IPath migrationFolder = this.getMigrationPath(script);
        if (migrationFolder == null) {
            return new File[0];
        }
        migrationFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(migrationFolder).getLocation();
        File[] scripts = migrationFolder.toFile().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".rb");
            }
        });
        if (scripts == null) {
            return new File[0];
        }
        return scripts;
    }

    private File getControllersFolder(ContentAssistInvocationContext context) {
        IPath path;
        if (!(context instanceof RubyContentAssistInvocationContext)) {
            return null;
        }
        RubyContentAssistInvocationContext rContext = (RubyContentAssistInvocationContext)context;
        IRubyScript script = rContext.getRubyScript();
        if (script == null) {
            return null;
        }
        IProject project = script.getRubyProject().getProject();
        IFolder folder = project.getFolder((path = RailsPlugin.findRailsRoot((IProject)project)).append("app").append("controllers"));
        if (folder == null) {
            return null;
        }
        return folder.getLocation().toFile();
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }
}

