/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.text;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MigrationVisitor
extends InOrderVisitor {
    private Map<String, Set<String>> tableToFields = new HashMap<String, Set<String>>();
    private Set<String> fields = new HashSet<String>();
    private String tableName;
    private static Set<String> columnMethodNames = new HashSet<String>();

    static {
        columnMethodNames.add("column");
        columnMethodNames.add("integer");
        columnMethodNames.add("string");
        columnMethodNames.add("text");
        columnMethodNames.add("float");
        columnMethodNames.add("decimal");
        columnMethodNames.add("datetime");
        columnMethodNames.add("timestamp");
        columnMethodNames.add("time");
        columnMethodNames.add("date");
        columnMethodNames.add("binary");
        columnMethodNames.add("boolean");
    }

    MigrationVisitor() {
    }

    public Set<String> getFieldNames(String string) {
        if (this.tableToFields.containsKey(string.toLowerCase())) {
            return this.tableToFields.get(string.toLowerCase());
        }
        return new HashSet<String>();
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        String name = iVisited.getName();
        if (name.equals("create_table")) {
            ArrayNode args = (ArrayNode)iVisited.getArgsNode();
            Node firstArg = args.get(0);
            this.tableName = ASTUtil.stringRepresentation((Node)firstArg);
            Instruction ins = super.visitFCallNode(iVisited);
            Set<String> temp = this.tableToFields.get(this.tableName);
            if (temp == null) {
                temp = new HashSet<String>();
            }
            temp.addAll(this.fields);
            this.tableToFields.put(this.tableName, temp);
            this.fields = new HashSet<String>();
            this.tableName = null;
            return ins;
        }
        if (name.equals("add_column")) {
            ArrayNode args = (ArrayNode)iVisited.getArgsNode();
            Node firstArg = args.get(0);
            String aTableName = ASTUtil.stringRepresentation((Node)firstArg);
            Node secondArg = args.get(1);
            String field = ASTUtil.stringRepresentation((Node)secondArg);
            Set<String> temp = this.tableToFields.get(aTableName);
            if (temp == null) {
                temp = new HashSet<String>();
            }
            temp.add(field);
            this.tableToFields.put(aTableName, temp);
        }
        return super.visitFCallNode(iVisited);
    }

    public Instruction visitCallNode(CallNode iVisited) {
        if (columnMethodNames.contains(iVisited.getName())) {
            ArrayNode args = (ArrayNode)iVisited.getArgsNode();
            Node firstArg = args.get(0);
            String fieldName = ASTUtil.stringRepresentation((Node)firstArg);
            this.fields.add(fieldName);
        } else if (iVisited.getName().equals("timestamps")) {
            this.fields.add("created_at");
            this.fields.add("updated_at");
        } else if (iVisited.getName().equals("references")) {
            ArrayNode args = (ArrayNode)iVisited.getArgsNode();
            Node firstArg = args.get(0);
            String fieldName = ASTUtil.stringRepresentation((Node)firstArg);
            this.fields.add(String.valueOf(fieldName) + "_id");
        }
        return super.visitCallNode(iVisited);
    }

    public Collection<? extends String> getTableNames() {
        return this.tableToFields.keySet();
    }
}

