/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.evaluator.Instruction;
import org.radrails.rails.internal.ui.text.PsuedoMethod;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveRecordAssociationsVisitor
extends InOrderVisitor {
    private List<IMethod> methods = new ArrayList<IMethod>();
    private static Set<String> associationMethodNames = new HashSet<String>();
    private static Set<String> multiAssociationMethodNames = new HashSet<String>();
    private static Set<String> singularAssociationMethodNames = new HashSet<String>();

    static {
        singularAssociationMethodNames.add("belongs_to");
        singularAssociationMethodNames.add("has_one");
        multiAssociationMethodNames.add("has_many");
        multiAssociationMethodNames.add("has_and_belongs_to_many");
        associationMethodNames.addAll(singularAssociationMethodNames);
        associationMethodNames.addAll(multiAssociationMethodNames);
    }

    public List<IMethod> getMethods() {
        return this.methods;
    }

    public Instruction visitRootNode(RootNode iVisited) {
        this.methods.clear();
        return super.visitRootNode(iVisited);
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        if (associationMethodNames.contains(iVisited.getName())) {
            ArrayNode args = (ArrayNode)iVisited.getArgsNode();
            Node firstArg = args.get(0);
            String modelName = ASTUtil.stringRepresentation((Node)firstArg);
            if (multiAssociationMethodNames.contains(iVisited.getName())) {
                this.methods.add(new PsuedoMethod(modelName, new String[0], 1));
            } else {
                this.methods.add(new PsuedoMethod(modelName, new String[0], 1));
                this.methods.add(new PsuedoMethod(String.valueOf(modelName) + "=", new String[]{modelName}, 1));
            }
        }
        return super.visitFCallNode(iVisited);
    }
}

