/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.railsplugins.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.radrails.rails.core.railsplugins.RailsPluginDescriptor;
import org.radrails.rails.core.railsplugins.RailsPluginsManager;
import org.radrails.rails.internal.ui.RailsUIMessages;
import org.radrails.rails.internal.ui.railsplugins.RailsPluginsView;
import org.radrails.rails.ui.RailsUIPlugin;

public class InstallPluginActionDelegate
implements IViewActionDelegate {
    private RailsPluginDescriptor plugin;
    private RailsPluginsView view;

    public void init(IViewPart view) {
        this.plugin = null;
        this.view = (RailsPluginsView)view;
    }

    public void run(IAction action) {
        if (this.plugin == null) {
            return;
        }
        IProject project = this.view.getProject();
        if (project == null || !project.exists()) {
            MessageDialog.openError((Shell)this.view.getSite().getShell(), (String)"No rails project selected", (String)RailsUIMessages.SelectRailsProject_message);
            this.view.projectSelected(null);
            return;
        }
        RailsPluginsManager.installPlugin((IProject)project, (RailsPluginDescriptor)this.plugin, (boolean)this.view.useExternals(), (boolean)this.view.checkout());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection) || this.view.manageTabSelected() || this.view.getProject() == null) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection struct = (IStructuredSelection)selection;
        this.plugin = (RailsPluginDescriptor)struct.getFirstElement();
        if (this.plugin != null) {
            if (!RailsPluginsManager.pluginInstalled((RailsPluginDescriptor)this.plugin, (IProject)RailsUIPlugin.getSelectedOrOnlyRailsProject())) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
        }
    }
}

