/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.railsplugins;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.radrails.rails.ui.RailsUIPlugin;

abstract class RatingImage {
    private static final float MAX_STARS = 5.0f;
    private static Image empty;
    private static Image filled;

    RatingImage() {
    }

    public static void init(Display display) {
        empty = RailsUIPlugin.getImageDescriptor("icons/unrated.png").createImage();
        filled = RailsUIPlugin.getImageDescriptor("icons/rated.png").createImage();
    }

    public static void dispose(Display display) {
        empty.dispose();
        filled.dispose();
        empty = null;
        filled = null;
    }

    public static Image createRatingImage(float rating, Display display) {
        if (filled == null || empty == null) {
            return null;
        }
        if ((rating = RatingImage.forceWithinRange(rating, 0.0f, 5.0f)) == 5.0f) {
            return RatingImage.copyImage(filled, display);
        }
        if ((double)rating == 0.0) {
            return RatingImage.copyImage(empty, display);
        }
        try {
            int fullWidth = RatingImage.filled.getBounds().width;
            float ratingInStars = rating / 5.0f;
            int widthToFill = (int)(ratingInStars * (float)fullWidth);
            if (widthToFill <= 0) {
                return RatingImage.copyImage(empty, display);
            }
            return RatingImage.overlay(filled, empty, widthToFill, display);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Image overlay(Image src, Image dest, int widthToFill, Display display) {
        Rectangle bounds = src.getBounds();
        ImageData destData = dest.getImageData();
        ImageData srcData = src.getImageData();
        int y = 0;
        while (y < bounds.height) {
            byte[] alphas = new byte[widthToFill];
            srcData.getAlphas(0, y, widthToFill, alphas, 0);
            destData.setAlphas(0, y, widthToFill, alphas, 0);
            int[] pixels = new int[widthToFill];
            srcData.getPixels(0, y, widthToFill, pixels, 0);
            destData.setPixels(0, y, widthToFill, pixels, 0);
            ++y;
        }
        return new Image((Device)display, destData);
    }

    private static Image copyImage(Image image, Display display) {
        return new Image((Device)display, image, 0);
    }

    private static float forceWithinRange(float rating, float min, float max) {
        if (rating < min) {
            return min;
        }
        if (rating > max) {
            return max;
        }
        return rating;
    }
}

