/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.console.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.radrails.db.core.DatabaseManager;
import org.radrails.rails.ui.console.RailsShellCommandProvider;
import org.radrails.server.core.Server;
import org.radrails.server.core.ServerManager;
import org.rubypeople.rdt.launching.ITerminal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptServerCommandProvider
extends RailsShellCommandProvider {
    @Override
    public Set<String> commandsHandled() {
        HashSet<String> commands = new HashSet<String>();
        commands.add("script/server");
        return commands;
    }

    @Override
    public List<ICompletionProposal> getCompletionProposals(String prefix, List<String> tokens, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String token = this.getLastToken(prefix, tokens);
        if (tokens.size() <= 1 && !tokens.contains("script/server")) {
            proposals.add(this.createProposal("script/server", "Rails application server", offset, token));
        }
        String lastToken = "";
        if (!tokens.isEmpty()) {
            lastToken = tokens.get(tokens.size() - 1);
        }
        if (lastToken.equals("-e")) {
            Set environments = DatabaseManager.getEnvironments();
            for (String env : environments) {
                proposals.add(this.createProposal(env, offset, ""));
            }
            return proposals;
        }
        if (lastToken.equals("-b") || lastToken.equals("-p")) {
            return Collections.emptyList();
        }
        if (tokens.size() > 0) {
            if (!tokens.contains("-p")) {
                proposals.add(this.createProposal("-p", "Runs Rails on the specified port. Default: 3000", offset, token));
            }
            if (!tokens.contains("-b")) {
                proposals.add(this.createProposal("-b", "Binds Rails to the specified IP. Default: 0.0.0.0", offset, token));
            }
            if (!tokens.contains("-d")) {
                proposals.add(this.createProposal("-d", "Make server run as a daemon", offset, token));
            }
            if (!tokens.contains("-e")) {
                proposals.add(this.createProposal("-e", "Specifies the environment to run this server under. Default: development", offset, token));
            }
            if (!tokens.contains("-h")) {
                proposals.add(this.createProposal("-h", "Show the help message", offset, token));
            }
        }
        return proposals;
    }

    @Override
    public void run(ITerminal shell, final String command) {
        final Server server = new Server(this.getProject(), "transient", "Mongrel", this.getHost(command), this.getPort(command), this.getEnvironment(command)){

            public String getProgramArguments() {
                return ScriptServerCommandProvider.this.getArgs(command);
            }
        };
        ServerManager.getInstance().addServer(server);
        final ILaunch launch = this.runInNewConsole(shell, command);
        Job job = new Job("Running Rails server from Rails Shell"){

            protected IStatus run(IProgressMonitor monitor) {
                while (!launch.isTerminated()) {
                    Thread.yield();
                    if (!monitor.isCanceled()) continue;
                    server.stop();
                    ServerManager.getInstance().removeServer(server);
                    return Status.CANCEL_STATUS;
                }
                ServerManager.getInstance().removeServer(server);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(50);
        job.schedule();
    }

    private String getHost(String command) {
        return this.getArg(command, "binding", "0.0.0.0");
    }

    private String getEnvironment(String command) {
        return this.getArg(command, "environment", "development");
    }

    private String getPort(String command) {
        return this.getArg(command, "port", "3000");
    }

    private String getArg(String command, String full, String defaultValue) {
        char letter = full.charAt(0);
        int index = command.indexOf("-" + letter);
        String value = defaultValue;
        if (index != -1) {
            value = command.substring(index + 3);
            if (value.indexOf(32) != -1) {
                value = value.substring(0, value.indexOf(32));
            }
            return value;
        }
        index = command.indexOf("--" + full);
        if (index != -1) {
            value = command.substring(index + 7);
            if (value.indexOf(32) != -1) {
                value = value.substring(0, value.indexOf(32));
            }
            return value;
        }
        return value;
    }
}

