/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.console.commands;

import com.aptana.rdt.rake.IRakeHelper;
import com.aptana.rdt.rake.RakePlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.radrails.rails.ui.RailsUILog;
import org.radrails.rails.ui.console.RailsShellCommandProvider;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.ITerminal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RakeCommandProvider
extends RailsShellCommandProvider {
    @Override
    public Set<String> commandsHandled() {
        HashSet<String> commands = new HashSet<String>();
        commands.add("rake");
        return commands;
    }

    @Override
    public List<ICompletionProposal> getCompletionProposals(String prefix, List<String> tokens, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String token = this.getLastToken(prefix, tokens);
        if (tokens.size() <= 1 && !tokens.contains("rake")) {
            proposals.add(this.createProposal("rake", "Run a rake task", offset, token));
        }
        if (tokens.isEmpty() || tokens.size() == 1 && !prefix.endsWith(" ") || tokens.size() == 2 && prefix.endsWith(" ")) {
            return proposals;
        }
        Map tasks = this.getRakeTasksHelper().getTasks(this.getProject(), (IProgressMonitor)new NullProgressMonitor());
        ArrayList taskKeys = new ArrayList(tasks.keySet());
        Collections.sort(taskKeys);
        for (String task : taskKeys) {
            proposals.add(this.createProposal(task, (String)tasks.get(task), offset, token));
        }
        return proposals;
    }

    @Override
    public void run(ITerminal shell, String command) {
        String task = command.substring(4).trim();
        int space = task.indexOf(32);
        String parameters = "";
        if (space > -1) {
            parameters = task.substring(space + 1);
            task = task.substring(0, space);
        }
        try {
            ILaunchConfigurationWorkingCopy wc = this.getRakeTasksHelper().run(this.getProject(), task, parameters).getWorkingCopy();
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_USE_TERMINAL, "org.radrails.rails.shell");
            wc.doSave().launch(this.getRunMode(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            RailsUILog.log((CoreException)e);
        }
    }

    protected IRakeHelper getRakeTasksHelper() {
        return RakePlugin.getDefault().getRakeHelper();
    }

    @Override
    public boolean projectNeedsToBeSelected() {
        return true;
    }
}

