/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.console;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.console.RailsShell;
import org.radrails.rails.ui.RailsUIPlugin;

public class RailsShellProjectSelectionAction
extends Action
implements IMenuCreator {
    private RailsShell console;
    private Menu fMenu;

    public RailsShellProjectSelectionAction(RailsShell console) {
        this.console = console;
        this.setEnabled(!RailsPlugin.getRailsProjects().isEmpty());
        this.setToolTipText("Change active project for Rails Shell");
        this.setImageDescriptor(RailsUIPlugin.getImageDescriptor("icons/rails_project.png"));
        this.setMenuCreator(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResource source = event.getResource();
                if (source != null) {
                    return;
                }
                IResourceDelta[] deltas = event.getDelta().getAffectedChildren(7, 4);
                if (deltas != null && deltas.length > 0) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            if (RailsShellProjectSelectionAction.this.fMenu != null) {
                                RailsShellProjectSelectionAction.this.fMenu.dispose();
                            }
                            RailsShellProjectSelectionAction.this.fMenu = null;
                            RailsShellProjectSelectionAction.this.setEnabled(!RailsPlugin.getRailsProjects().isEmpty());
                        }
                    });
                }
            }
        }, 1);
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        int accel = 1;
        Set projects = RailsPlugin.getRailsProjects();
        for (IProject project : projects) {
            String label = project.getName();
            ImageDescriptor image = null;
            this.addActionToMenu(this.fMenu, new RailsProjectAction(label, image, project), accel);
            ++accel;
        }
        return this.fMenu;
    }

    private void addActionToMenu(Menu parent, Action action, int accelerator) {
        if (accelerator < 10) {
            StringBuffer label = new StringBuffer();
            label.append('&');
            label.append(accelerator);
            label.append(' ');
            label.append(action.getText());
            action.setText(label.toString());
        }
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private class RailsProjectAction
    extends Action {
        private IProject project;

        public RailsProjectAction(String label, ImageDescriptor image, IProject project) {
            this.setText(label);
            if (image != null) {
                this.setImageDescriptor(image);
            }
            this.project = project;
        }

        public void run() {
            RailsShellProjectSelectionAction.this.console.setProject(this.project);
        }

        public void runWithEvent(Event event) {
            this.run();
        }
    }
}

