/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.console;

import com.aptana.ide.core.IdeLog;
import com.aptana.rdt.rake.IRakeHelper;
import com.aptana.rdt.rake.RakePlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.AsynchronousSchedulingRuleFactory;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.internal.console.IOConsoleViewer;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.progress.UIJob;
import org.radrails.rails.core.RailsLog;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.console.ConsoleLineNotifier;
import org.radrails.rails.internal.ui.console.RailsShellContentAssistProcessor;
import org.radrails.rails.internal.ui.console.RailsShellExecutor;
import org.radrails.rails.ui.RailsUILog;
import org.radrails.rails.ui.RailsUIPlugin;
import org.radrails.rails.ui.console.RailsShellCommandProvider;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.ITerminal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsShell
extends IOConsole
implements IPartListener,
IDocumentListener,
ITerminal,
IResourceChangeListener,
ICompletionListener {
    private static final String OUTPUT_PARTITION_TYPE = "org.eclipse.ui.console.io_console_output_partition_type";
    private static final String INPUT_PARTITION_TYPE = "org.eclipse.ui.console.io_console_input_partition_type";
    private static List<RailsShellCommandProvider> fgProviders;
    private IOConsolePage page;
    private IOConsoleOutputStream fOutputStream;
    private IOConsoleInputStream fInput;
    private StreamListener listener;
    private IConsoleColorProvider fColorProvider;
    private IProcess fProcess;
    private ConsoleLineNotifier consoleLineNotifier;
    private IProject fProject;
    private ContentAssistant fContentAssistant;
    private RailsShellContentAssistProcessor fContentAssistProcessor;
    private IStreamsProxy streamsProxy;
    private IOConsoleOutputStream fFakeInputStream;
    private IOConsoleOutputStream fErrorStream;
    private Map<String, StreamListener> listeners;
    private boolean fActivated;
    private RailsShellExecutor executor;
    private ISchedulingRule rule = AsynchronousSchedulingRuleFactory.getDefault().newSerialRule();
    private ArrayList<String> fCommandHistory;
    private int fCommandIndex;
    private InputReadJob readJob;
    private boolean completionActive;
    protected ILaunch currentLaunch;

    public RailsShell() {
        super("Rails Shell", "org.radrails.rails.shell", RailsUIPlugin.getImageDescriptor("icons/rails.gif"));
        this.fInput = this.getInputStream();
        this.fColorProvider = DebugUIPlugin.getDefault().getProcessConsoleManager().getColorProvider("ruby");
        this.fInput.setColor(this.fColorProvider.getColor("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM"));
        this.fContentAssistProcessor = new RailsShellContentAssistProcessor();
        this.listeners = new HashMap<String, StreamListener>();
        this.executor = new RailsShellExecutor(this);
        Set projects = RailsPlugin.getRailsProjects();
        if (projects != null && !projects.isEmpty()) {
            this.setProject((IProject)projects.iterator().next());
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.fCommandHistory = new ArrayList();
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        this.page = (IOConsolePage)super.createPage(view);
        IDocument doc = this.getDocument();
        IHandlerService service = (IHandlerService)view.getSite().getService(IHandlerService.class);
        service.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent evt) throws ExecutionException {
                RailsShell.this.fContentAssistant.showPossibleCompletions();
                return null;
            }
        });
        doc.addDocumentListener((IDocumentListener)this);
        view.getSite().getPage().addPartListener((IPartListener)this);
        return this.page;
    }

    public void attach(IProcess process) {
        if (this.fProcess != null) {
            this.removePatternMatchListener(this.consoleLineNotifier);
        }
        this.fProcess = process;
        IConsoleLineTracker[] lineTrackers = DebugUIPlugin.getDefault().getProcessConsoleManager().getLineTrackers(process);
        if (lineTrackers.length > 0) {
            this.consoleLineNotifier = new ConsoleLineNotifier();
            this.addPatternMatchListener(this.consoleLineNotifier);
        }
        this.connect(process.getStreamsProxy());
    }

    public void connect(IStreamsProxy streamsProxy) {
        IOConsoleOutputStream stream;
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        IStreamMonitor streamMonitor = streamsProxy.getErrorStreamMonitor();
        if (streamMonitor != null) {
            this.connect(streamMonitor, "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM");
            stream = this.getStream("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM");
            if (stream != null) {
                stream.setActivateOnWrite(store.getBoolean("DEBUG.consoleOpenOnErr"));
            }
        }
        if ((streamMonitor = streamsProxy.getOutputStreamMonitor()) != null) {
            this.connect(streamMonitor, "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM");
            stream = this.getStream("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM");
            if (stream != null) {
                stream.setActivateOnWrite(store.getBoolean("DEBUG.consoleOpenOnOut"));
            }
        }
        if (this.readJob == null) {
            this.readJob = new InputReadJob(streamsProxy);
            this.readJob.setSystem(true);
            this.readJob.schedule();
        } else {
            this.readJob.setStreamProxy(streamsProxy);
        }
        this.streamsProxy = streamsProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(IStreamMonitor streamMonitor, String streamIdentifier) {
        IStreamMonitor iStreamMonitor = streamMonitor;
        synchronized (iStreamMonitor) {
            StreamListener listener = this.listeners.get(streamIdentifier);
            if (listener != null) {
                listener.getStreamMonitor().removeListener((IStreamListener)listener);
            }
            listener = new StreamListener(streamIdentifier, streamMonitor, this.getStream(streamIdentifier));
            this.listeners.put(streamIdentifier, listener);
        }
    }

    public void activate() {
        super.activate();
        if (!this.fActivated) {
            this.fOutputStream = this.newOutputStream();
            this.fOutputStream.setColor(this.fColorProvider.getColor("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM"));
            this.fErrorStream = this.newOutputStream();
            this.fErrorStream.setColor(this.fColorProvider.getColor("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM"));
            this.fFakeInputStream = this.newOutputStream();
            this.fFakeInputStream.setColor(this.fColorProvider.getColor("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM"));
            String ascii = "          mmmmmmddddddddhhhhhhhhhhhhhhhhhhhddddddddddddddhhddddddddddm\n          mmmdhhhhhhddhsssooooooooooooooooooooso+++ossoossossyyyhhhhdm\n          mmdhhhhhhddhssssssoo++++++++//++ooooo+.  .++oooosossyyyhhhdm\n          mdhhhhhdddhsssssssssoo++//-`  ./++///:-.--::///+os+:oyyyhhdm\n          mdhhhddddysssssssssssoooo+/-``.-.```           ``-:--:yyhhdm\n          mdhdddddysssssssssssssooooo/-``                     `-+yyhdm\n          mddddddyssssssssssoossooo+:.`....``        ``......``  .+yhm\n          mddddhyssssssssso-``:oys/.````........`...``.::-:/-.-+/-:yhm\n          mdddhsssssssssss/.` .oo-`````````....-oyyy+--:---::/+oossyhm\n          mddhssssssssyyyhhyo/s/`````````````./oohhhhhhys/::::/+oosyhm\n          mdhssyyyyyyyyhhhhhhs.`  ``````````.+s-.+hhhhhhhy/::///++oshm\n          mdhhhhhhhhhhhhhhhho.       ```````+hhy/shhhhhhhhs:::///+++ym\n          mdhhhhhhhhhhyyhhho`            ``:hhhhhhhhhhhhhhho-::////+hm\n          mddhhhhhhy/+oyyy+`              .o+yhhhhhhhhhhhhhy+-::://ohm\n          mdddhhhhh:  `.so`               /+`.ohhhhhhhhhhhhhy:--::+shm\n          mddddhhhy-.` :s.               .syo:+hhhhhhhhhhhhhhs:--/osym\n          mdddddhhyysoos:                -hhhyyhhhhhhhhhhhhhhhs--+ooym\n          mddddmdyyyyyy+`                :yyhhhhhhhhhhhhhhhhhhh+/+ooym\n          mdddmmmhyyyys.                 :/-/syhhhhhhhhhhhhhhhy+/++oym\n          mdddmdddhyyy/                  :+.``+hhhhhhhhhhhhhhho//++oym\n          mddddddddyys.                  .yysooyyyyhhhhhhhhhhs+++++oym\n          mdddhysyyyy+`                  `oyyyyyyyyyyyyhhhhhy+++oo++ym\n          mddhy:--:/y:                    /yyyyyyyyyyyyyyhhyooooooooym\n          mdhho----oh:                    .sssyyyyyyyyyyyyysoossssssym\n          mmddyssssyh:.                    /:.--/yyyyyyyyyssssssyyyydm\n          mmmdddddddy--.                   .+..`./yyyyyyyyssyyyyyyyhdm\n          mmdmddddddy-::-.``                /sssssyyyyyyyyyyyyyyyhhddm\n          mmdddddddds:::::::--.``           `oyyyyyyhhhhhyyyyyhhhhdddm\n          mmddddddddhyyysssssssssoo+++////+++oyhhhhhhhhhhhhhhhhysyhhdm\n          mmddddddddddddhhhhhhhhhhhhhhhyyyhhhhhhhhhhhhhhhhhhhhho+::odm\n          mmdddh+/////+yhhhhyo////+shhdy///hhy/:/yhhhhhyo/:::::shhhhdm\n          mmdddy.  ``  `/hhy.  ``  `+ddo  .hhs  `shhhhy:  `````ohhhhdm\n          mmdddy. `sy/  .yhs  .ss:  :ddo  .hdy  `shhhhy.  -::/+yhhhhdm\n          mmdddy.  ..` `/hhs  `//.  :hdo  .hdy  `shhhhh+.`     :hhhhdm\n          mddddy.  `  .shhhs        :hho  .hhs   /+++shs+///:  .yhhhdm\n          mddddy. `s/  .ohhs` .ss:  :hho  .hhs`      /y:      `/hhhhdm\n          mdddddyyyddysssyhhssshhyssyhhyssshhhsssssssyhsooooosyhhhhdmm\n          mdddddddddddddhhhddddhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhdmmm\n          mmdmmmmmmmmmmmdddddddddddddddddddddddddddddddddddddddmmmmmmm";
            this.write("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", String.valueOf(ascii) + "\n\nWelcome to the Rails Shell. This view is meant for advanced users and command line lovers as a text-based way\nto run rails " + "commands such as: rails, script/generate, script/plugin, gem, rake, etc.\nThis shell can replace the functionality of the " + "Rake Tasks, Rails Plugins, and generators views.\n\n" + ">");
            DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

                public void handleDebugEvents(DebugEvent[] events) {
                    if (events == null) {
                        return;
                    }
                    int i = 0;
                    while (i < events.length) {
                        IProcess source;
                        ILaunch launch;
                        String id;
                        if (events[i].getKind() == 8 && events[i].getSource() instanceof IProcess && (id = (launch = (source = (IProcess)events[i].getSource()).getLaunch()).getAttribute(IRubyLaunchConfigurationConstants.ATTR_USE_TERMINAL)) != null && id.equals("org.radrails.rails.shell")) {
                            RailsShell.this.writePrompt();
                            RailsShell.this.fProcess = null;
                        }
                        ++i;
                    }
                }
            });
            UIJob job = new UIJob(""){
                private int tries;
                {
                    this.tries = 3;
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (RailsShell.this.page == null || RailsShell.this.page.getViewer() == null || RailsShell.this.page.getViewer().getTextWidget() == null) {
                        if (this.tries-- > 0) {
                            this.schedule(2000L);
                        }
                        return Status.CANCEL_STATUS;
                    }
                    RailsShell.this.page.getViewer().getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

                        public void verifyKey(VerifyEvent e) {
                            int keyCode = e.keyCode;
                            if (keyCode == 99 && e.stateMask == 262144) {
                                if (RailsShell.this.fProcess != null && RailsShell.this.fProcess.canTerminate()) {
                                    try {
                                        RailsShell.this.fProcess.terminate();
                                    }
                                    catch (DebugException e1) {
                                        IdeLog.logError((Plugin)RailsUIPlugin.getInstance(), (String)e1.getMessage(), (Throwable)e1);
                                    }
                                }
                                return;
                            }
                            if (keyCode == 9) {
                                e.doit = false;
                                RailsShell.this.fContentAssistant.showPossibleCompletions();
                                return;
                            }
                            if (keyCode == 0x1000007) {
                                e.doit = false;
                                String contents = RailsShell.this.page.getViewer().getDocument().get();
                                int offset = contents.lastIndexOf(">");
                                offset = offset == -1 ? RailsShell.this.page.getViewer().getTextWidget().getCharCount() : ++offset;
                                RailsShell.this.page.getViewer().getTextWidget().setCaretOffset(offset);
                            } else {
                                if (RailsShell.this.completionActive) {
                                    return;
                                }
                                String command = null;
                                if (this.isUpArrow(e)) {
                                    e.doit = false;
                                    command = RailsShell.this.getCommandFromHistory(-1);
                                } else if (this.isDownArrow(e)) {
                                    e.doit = false;
                                    command = RailsShell.this.getCommandFromHistory(1);
                                } else {
                                    return;
                                }
                                if (command == null) {
                                    return;
                                }
                                try {
                                    this.setCommand(command);
                                    RailsShell.this.page.getViewer().getTextWidget().setCaretOffset(RailsShell.this.getDocument().getLength());
                                }
                                catch (Exception e1) {
                                    RailsLog.log((Exception)e1);
                                }
                            }
                        }

                        private void setCommand(String command) throws BadLocationException {
                            int lines = RailsShell.this.getDocument().getNumberOfLines();
                            int offset = RailsShell.this.getDocument().getLineOffset(lines - 1);
                            int length = RailsShell.this.getDocument().getLength() - offset;
                            String toReplace = RailsShell.this.getDocument().get(offset, length);
                            if (toReplace.trim().startsWith(">")) {
                                int index = toReplace.indexOf(">");
                                offset += index + ">".length();
                                length -= index + ">".length();
                            }
                            RailsShell.this.getDocument().replace(offset, length, command);
                        }

                        private boolean isUpArrow(VerifyEvent e) {
                            return e.keyCode == 0x1000001;
                        }

                        private boolean isDownArrow(VerifyEvent e) {
                            return e.keyCode == 0x1000002;
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            this.fActivated = true;
        }
    }

    protected String getCommandFromHistory(int move) {
        if (this.fCommandHistory.isEmpty()) {
            return null;
        }
        this.fCommandIndex += move;
        if (this.fCommandIndex <= 0) {
            this.fCommandIndex = 0;
        } else if (this.fCommandIndex >= this.fCommandHistory.size()) {
            this.fCommandIndex = this.fCommandHistory.size();
            return "";
        }
        return this.fCommandHistory.get(this.fCommandIndex);
    }

    private void writePrompt() {
        this.write("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", ">");
    }

    private void installContentAssist() {
        if (this.page == null || this.fContentAssistant != null) {
            return;
        }
        IOConsoleViewer viewer = (IOConsoleViewer)this.page.getViewer();
        this.fContentAssistant = new ContentAssistant();
        this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fContentAssistProcessor, INPUT_PARTITION_TYPE);
        this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fContentAssistProcessor, OUTPUT_PARTITION_TYPE);
        this.fContentAssistant.enableAutoActivation(true);
        this.fContentAssistant.enableAutoInsert(true);
        this.fContentAssistant.enablePrefixCompletion(true);
        this.fContentAssistant.install((ITextViewer)viewer);
        this.fContentAssistant.addCompletionListener((ICompletionListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IConsoleView) {
            this.page.setFocus();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.installContentAssist();
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof IConsoleView) {
            this.installContentAssist();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.installContentAssist();
    }

    public void documentChanged(DocumentEvent event) {
        this.installContentAssist();
        String text = event.getText();
        IDocument doc = event.getDocument();
        String[] delimeters = doc.getLegalLineDelimiters();
        if (this.contains(text, delimeters)) {
            String contents = doc.get();
            int index = contents.lastIndexOf("\n", event.getOffset() - text.length());
            if (index == -1) {
                index = contents.lastIndexOf("\r", event.getOffset() - text.length());
            }
            if (index != -1) {
                contents = contents.substring(index + 1);
            }
            if ((index = contents.indexOf(">")) == -1) {
                return;
            }
            contents = contents.substring(index + 1).trim();
            this.fCommandHistory.add(contents);
            this.fCommandIndex = this.fCommandHistory.size();
            this.executor.run(this.fProject, contents);
        }
    }

    protected IRakeHelper getRakeTasksHelper() {
        return RakePlugin.getDefault().getRakeHelper();
    }

    private boolean contains(String text, String[] delimeters) {
        int i = 0;
        while (i < delimeters.length) {
            if (text.equals(delimeters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addLink(IConsoleHyperlink link, int offset, int length) {
        try {
            this.addHyperlink((IHyperlink)link, offset, length);
        }
        catch (BadLocationException e) {
            DebugUIPlugin.log((Throwable)e);
        }
    }

    public void addLink(IHyperlink link, int offset, int length) {
        try {
            this.addHyperlink(link, offset, length);
        }
        catch (BadLocationException e) {
            DebugUIPlugin.log((Throwable)e);
        }
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public IRegion getRegion(IConsoleHyperlink link) {
        return super.getRegion((IHyperlink)link);
    }

    public IOConsoleOutputStream getStream(String streamIdentifier) {
        if (streamIdentifier.equals("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM")) {
            return this.fErrorStream;
        }
        if (streamIdentifier.equals("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM")) {
            return this.fFakeInputStream;
        }
        return this.fOutputStream;
    }

    public void setProject(final IProject project) {
        this.fProject = project;
        this.fContentAssistProcessor.setProject(project);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (project == null) {
                    RailsShell.this.setName("Rails Shell (" + RailsPlugin.getInstance().getRailsPath() + ")");
                } else {
                    RailsShell.this.setName("Rails Shell - " + project.getName() + " (" + RailsPlugin.getInstance().getRailsPath() + ")");
                }
            }
        });
    }

    public void write(final String streamIdentifier, final String text) {
        if (streamIdentifier.equals("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM") && text.endsWith("\n")) {
            this.fCommandHistory.add(text.substring(0, text.length() - 1));
        }
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    IOConsoleOutputStream stream = RailsShell.this.getStream(streamIdentifier);
                    stream.write(text);
                    return Status.OK_STATUS;
                }
                catch (IOException e) {
                    RailsUILog.log((Exception)e);
                    return new Status(4, RailsUIPlugin.getPluginIdentifier(), -1, "Error writing text to rails shell", (Throwable)e);
                }
            }
        };
        job.setPriority(10);
        job.setRule(this.rule);
        job.schedule(5L);
    }

    public void clearConsole() {
        super.clearConsole();
        this.writePrompt();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        this.traverseDelta(delta);
    }

    private boolean traverseDelta(IResourceDelta delta) {
        if (delta == null) {
            return true;
        }
        IResource res = delta.getResource();
        if (res instanceof IWorkspaceRoot) {
            IResourceDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.traverseDelta(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (!(res instanceof IProject)) {
            return false;
        }
        int deltaKind = delta.getKind();
        if (deltaKind != 1 && deltaKind != 2) {
            return false;
        }
        IProject project = (IProject)res;
        if (deltaKind == 1) {
            if (RailsPlugin.hasRailsNature((IProject)project)) {
                this.setProject(project);
            }
            return false;
        }
        if (this.fProject != null && !project.equals((Object)this.fProject)) {
            return false;
        }
        Set projects = RailsPlugin.getRailsProjects();
        for (final IProject possible : projects) {
            if (possible.equals((Object)project)) continue;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    RailsShell.this.setProject(possible);
                }
            });
            return false;
        }
        this.setProject(null);
        return false;
    }

    public static RailsShell open() {
        RailsShell console = new RailsShell();
        ConsolePlugin conMan = ConsolePlugin.getDefault();
        conMan.getConsoleManager().addConsoles(new IConsole[]{console});
        console.activate();
        return console;
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.completionActive = false;
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        this.completionActive = true;
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    public static List<RailsShellCommandProvider> getCommandProviders(IProject fProject, String fRunMode) {
        List<RailsShellCommandProvider> providers = RailsShell.getCommandProviders();
        for (RailsShellCommandProvider provider : providers) {
            provider.initialize(fProject, fRunMode);
        }
        return providers;
    }

    private static List<RailsShellCommandProvider> getCommandProviders() {
        if (fgProviders == null) {
            final HashMap<RailsShellCommandProvider, Integer> providersToPriority = new HashMap<RailsShellCommandProvider, Integer>();
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(RailsUIPlugin.getPluginIdentifier(), "railsShellCommandProviders");
            if (extension == null) {
                return Collections.emptyList();
            }
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                try {
                    RailsShellCommandProvider provider = (RailsShellCommandProvider)configElements[j].createExecutableExtension("class");
                    String rawPriority = configElements[j].getAttribute("priority");
                    int priority = 50;
                    try {
                        priority = Integer.parseInt(rawPriority);
                    }
                    catch (Exception exception) {}
                    providersToPriority.put(provider, priority);
                }
                catch (CoreException e) {
                    RailsUILog.log((CoreException)e);
                }
                ++j;
            }
            ArrayList<RailsShellCommandProvider> providers = new ArrayList<RailsShellCommandProvider>(providersToPriority.keySet());
            Collections.sort(providers, new Comparator<RailsShellCommandProvider>(){

                @Override
                public int compare(RailsShellCommandProvider o1, RailsShellCommandProvider o2) {
                    return ((Integer)providersToPriority.get(o1)).compareTo((Integer)providersToPriority.get(o2));
                }
            });
            fgProviders = providers;
        }
        return fgProviders;
    }

    private class InputReadJob
    extends Job {
        private IStreamsProxy streamsProxy;

        InputReadJob(IStreamsProxy streamsProxy) {
            super("Process Console Input Job");
            this.streamsProxy = streamsProxy;
        }

        public void setStreamProxy(IStreamsProxy streamsProxy2) {
            this.streamsProxy = streamsProxy2;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                byte[] b = new byte[1024];
                int read = 0;
                while (RailsShell.this.fInput != null && read >= 0) {
                    read = RailsShell.this.fInput.read(b);
                    if (read <= 0) continue;
                    String s = new String(b, 0, read);
                    if (RailsShell.this.fProcess == null || RailsShell.this.fProcess.isTerminated()) continue;
                    this.streamsProxy.write(s);
                }
            }
            catch (IOException e) {
                RailsUILog.log((Exception)e);
            }
            return Status.OK_STATUS;
        }
    }

    private class StreamListener
    implements IStreamListener {
        private IOConsoleOutputStream fStream;
        private IStreamMonitor fStreamMonitor;
        private String fStreamId;
        private boolean fFlushed = false;
        private boolean fListenerRemoved = false;

        public StreamListener(String streamIdentifier, IStreamMonitor monitor, IOConsoleOutputStream stream) {
            this.fStreamId = streamIdentifier;
            this.fStreamMonitor = monitor;
            this.fStream = stream;
            this.fStreamMonitor.addListener((IStreamListener)this);
            this.streamAppended(null, monitor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamAppended(String text, IStreamMonitor monitor) {
            if (this.fFlushed) {
                try {
                    if (this.fStream != null) {
                        this.fStream.write(text);
                    }
                }
                catch (IOException e) {
                    DebugUIPlugin.log((Throwable)e);
                }
            } else {
                String contents = null;
                IStreamMonitor iStreamMonitor = this.fStreamMonitor;
                synchronized (iStreamMonitor) {
                    this.fFlushed = true;
                    contents = this.fStreamMonitor.getContents();
                    if (this.fStreamMonitor instanceof IFlushableStreamMonitor) {
                        IFlushableStreamMonitor m = (IFlushableStreamMonitor)this.fStreamMonitor;
                        m.flushContents();
                        m.setBuffered(false);
                    }
                }
                try {
                    if (contents != null && contents.length() > 0 && this.fStream != null) {
                        this.fStream.write(contents);
                    }
                }
                catch (IOException e) {
                    DebugUIPlugin.log((Throwable)e);
                }
            }
        }

        public IStreamMonitor getStreamMonitor() {
            return this.fStreamMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeStream() {
            if (this.fStreamMonitor == null) {
                return;
            }
            IStreamMonitor iStreamMonitor = this.fStreamMonitor;
            synchronized (iStreamMonitor) {
                this.fStreamMonitor.removeListener((IStreamListener)this);
                if (!this.fFlushed) {
                    String contents = this.fStreamMonitor.getContents();
                    this.streamAppended(contents, this.fStreamMonitor);
                }
                this.fListenerRemoved = true;
                try {
                    if (this.fStream != null) {
                        this.fStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        public void dispose() {
            if (!this.fListenerRemoved) {
                this.closeStream();
            }
            this.fStream = null;
            this.fStreamMonitor = null;
            this.fStreamId = null;
        }
    }
}

