/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.browser;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.radrails.rails.internal.ui.browser.CoreURL;

public class URLParser {
    private boolean hasProtocol = false;
    private boolean isIntroUrl = false;
    private URL url_inst;

    public URLParser(String url) {
        this.parseUrl(url);
    }

    private void parseUrl(String url) {
        if (url == null) {
            return;
        }
        this.url_inst = null;
        try {
            this.url_inst = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        if (this.url_inst.getProtocol() != null) {
            this.hasProtocol = true;
            this.isIntroUrl = this.isIntroUrl(this.url_inst);
            return;
        }
    }

    public boolean hasProtocol() {
        return this.hasProtocol;
    }

    public boolean hasIntroUrl() {
        return this.isIntroUrl;
    }

    public String getProtocol() {
        return this.url_inst.getProtocol();
    }

    public String getHost() {
        return this.url_inst.getHost();
    }

    private boolean isIntroUrl(URL url) {
        if (!url.getProtocol().equalsIgnoreCase("http")) {
            return false;
        }
        return url.getHost().equalsIgnoreCase("org.eclipse.ui.intro");
    }

    public CoreURL getIntroURL() {
        CoreURL introURL = null;
        if (this.isIntroUrl) {
            String action = this.getPathAsAction(this.url_inst);
            Properties parameters = this.getQueryParameters(this.url_inst);
            introURL = new CoreURL(action, parameters);
        }
        return introURL;
    }

    private String getPathAsAction(URL url) {
        String action = url.getPath();
        if (action != null) {
            action = action.substring(1);
        }
        return action;
    }

    public Properties getQueryParameters(URL url) {
        Properties properties = new Properties();
        String query = url.getQuery();
        if (query == null) {
            return properties;
        }
        String[] params = query.split("&");
        int i = 0;
        while (i < params.length) {
            String value;
            String key;
            String[] keyValuePair = params[i].split("=");
            if (keyValuePair.length == 2 && (key = URLParser.urlDecode(keyValuePair[0])) != null && (value = URLParser.urlDecode(keyValuePair[1])) != null) {
                properties.setProperty(key, value);
            }
            ++i;
        }
        return properties;
    }

    private static String urlDecode(String encodedURL) {
        int len = encodedURL.length();
        ByteArrayOutputStream os = new ByteArrayOutputStream(len);
        try {
            int i = 0;
            while (i < len) {
                switch (encodedURL.charAt(i)) {
                    case '%': {
                        if (len >= i + 3) {
                            os.write(Integer.parseInt(encodedURL.substring(i + 1, i + 3), 16));
                        }
                        i += 3;
                        break;
                    }
                    case '+': {
                        os.write(32);
                        ++i;
                        break;
                    }
                    default: {
                        os.write(encodedURL.charAt(i++));
                    }
                }
            }
            return new String(os.toByteArray(), "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

