/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.autotest;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.OverlayIcon;
import org.radrails.rails.core.RailsLog;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.RailsUIMessages;
import org.radrails.rails.internal.ui.autotest.AutotestHelper;
import org.radrails.rails.internal.ui.autotest.AutotestManager;
import org.radrails.rails.internal.ui.autotest.IAutotestRunListener;
import org.radrails.rails.ui.RailsUILog;
import org.radrails.rails.ui.RailsUIPlugin;

public class RunAutotestSuiteActionDelegate
implements IWorkbenchWindowActionDelegate,
IAutotestRunListener {
    private static final String AUTOTEST_TEMPORARY_FILE = "autotest_listing.rb";
    private IWorkbenchWindow fWindow;
    private IAction fAction;
    private BlinkThread fBlinkThread;

    public void dispose() {
        this.fWindow = null;
        RailsUIPlugin.getInstance().getAutotestManager().removeRunListener(this);
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
        RailsUIPlugin.getInstance().getAutotestManager().addRunListener(this);
    }

    public void run(IAction action) {
        Job j = new Job("Autotest"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Running autotest suite", 3);
                monitor.worked(1);
                IFile activeEditorFile = AutotestHelper.getActiveEditorFile();
                if (activeEditorFile != null) {
                    if (RunAutotestSuiteActionDelegate.this.fBlinkThread != null) {
                        RunAutotestSuiteActionDelegate.this.fBlinkThread.stopBlinking();
                    }
                    AutotestManager manager = new AutotestManager();
                    manager.attemptTestLaunch((IResource)activeEditorFile);
                } else {
                    RunAutotestSuiteActionDelegate.this.openErrorDialog(RailsUIMessages.OpenRubyEditor_message);
                }
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.schedule();
    }

    private void openErrorDialog(final String message) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)RunAutotestSuiteActionDelegate.this.fWindow.getShell(), (String)"Error running tests", (String)message);
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void suiteError() {
        this.getAction().setToolTipText("(Error) Manually Run Autotest Suite");
        this.notifySuite("at_error.gif");
    }

    public void suiteFail() {
        this.getAction().setToolTipText("(Failed) Manually Run Autotest Suite");
        this.notifySuite("at_fail.gif");
    }

    public void suitePass() {
        this.getAction().setToolTipText("(Passed) Manually Run Autotest Suite");
        this.notifySuite("at_pass.gif");
    }

    private void notifySuite(String iconName) {
        ImageDescriptor icon = RailsUIPlugin.getImageDescriptor("icons/" + iconName);
        this.fBlinkThread = new BlinkThread(icon);
        this.fBlinkThread.start();
    }

    private IAction getAction() {
        ApplicationWindow aw;
        ToolBarContributionItem tbcItem;
        ActionContributionItem acItem;
        if (this.fAction == null && (acItem = (ActionContributionItem)(tbcItem = (ToolBarContributionItem)(aw = (ApplicationWindow)this.fWindow).getCoolBarManager().find("org.radrails.rails.ui.railsActions")).getToolBarManager().find("org.radrails.rails.ui.test.RunAutotestSuite")) != null) {
            this.fAction = acItem.getAction();
        }
        return this.fAction;
    }

    private String writeTemporaryTestListing(List tests) {
        String rubyFile = AUTOTEST_TEMPORARY_FILE;
        String directoryFile = String.valueOf(RailsPlugin.getInstance().getStateLocation().toOSString()) + File.separator + rubyFile;
        File pluginDirFile = new File(directoryFile);
        try {
            pluginDirFile.createNewFile();
            FileWriter output = new FileWriter(pluginDirFile);
            Iterator i = tests.iterator();
            while (i.hasNext()) {
                output.write("require '" + i.next().toString() + "'");
                output.write(10);
            }
            output.flush();
            output.close();
        }
        catch (IOException e) {
            RailsLog.logError((String)"Error writing plugin script to metadata", (Throwable)e);
        }
        String path = "";
        try {
            path = pluginDirFile.getCanonicalPath();
        }
        catch (IOException e) {
            RailsLog.logError((String)"Error getting file path", (Throwable)e);
        }
        return path;
    }

    private class BlinkThread
    extends Thread {
        private boolean keepBlinking = true;
        private ImageDescriptor fIcon;
        private ImageDescriptor fBlinkIcon;

        public BlinkThread(ImageDescriptor icon) {
            this.fIcon = icon;
            ImageDescriptor blink = RailsUIPlugin.getImageDescriptor("icons/blink_ovr.gif");
            this.fBlinkIcon = new OverlayIcon(icon, blink, new Point(16, 16));
        }

        public void run() {
            int i = 0;
            while (i < 11 && this.keepBlinking) {
                if (i % 2 == 0) {
                    RunAutotestSuiteActionDelegate.this.getAction().setImageDescriptor(this.fIcon);
                } else {
                    RunAutotestSuiteActionDelegate.this.getAction().setImageDescriptor(this.fBlinkIcon);
                }
                try {
                    BlinkThread.sleep(500L);
                }
                catch (InterruptedException e) {
                    RailsUILog.logError((String)"Error sleeping during icon blink", (Throwable)e);
                }
                ++i;
            }
        }

        public void stopBlinking() {
            this.keepBlinking = false;
            RunAutotestSuiteActionDelegate.this.getAction().setImageDescriptor(this.fIcon);
        }
    }
}

