/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.actions.mvc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.radrails.rails.core.Inflector;
import org.radrails.rails.core.RailsConventions;
import org.radrails.rails.internal.ui.actions.mvc.MVCEditorActionDelegate;
import org.radrails.rails.internal.ui.actions.mvc.ViewSelectionDialog;
import org.radrails.rails.ui.RailsUILog;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyMethod;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyDocumentProvider;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;

public class ViewEditorActionDelegate
extends MVCEditorActionDelegate {
    private static final String APP_MODELS = "app/models";
    private static final String APP_HELPERS = "app/helpers";
    private static final String HAML_EDITOR_ID = "net.lucky_dip.hamleditor.editor.HamlEditor";
    private static final String RHTML_EDITOR_ID = "com.aptana.ide.editors.ERBEditor";
    public static final String[] VIEW_TYPES = new String[]{"rhtml", "rjs", "rxml", "html.erb", "xml.builder", "dryml", "haml"};

    protected boolean isEnabled() {
        IFile currentFile = this.getCurrentFile();
        return RailsConventions.looksLikeController((IFile)currentFile) || RailsConventions.looksLikeHelper((IFile)currentFile) || RailsConventions.looksLikeModel((IFile)currentFile) || RailsConventions.looksLikeTest((IFile)currentFile);
    }

    public void run(IAction action) {
        IFile original = this.getCurrentFile();
        IProject project = original.getProject();
        String path = original.getProjectRelativePath().toString();
        try {
            if (this.attemptToOpenMvcView(project, path, "app/controllers", "_controller")) {
                return;
            }
            if (this.attemptToOpenMvcView(project, path, APP_HELPERS, "_helper")) {
                return;
            }
            if (this.attemptToOpenMvcView(project, path, APP_MODELS, "")) {
                return;
            }
            if (this.attemptToOpenMvcView(project, path, "test/functional", "_controller_test")) {
                return;
            }
            if (this.attemptToOpenMvcView(project, path, "test/unit", "_test")) {
                return;
            }
            if (this.attemptToOpenMvcModelOrController(project, path, original)) {
                return;
            }
        }
        catch (RubyModelException e) {
            RailsUILog.logError((String)"Error accessing ruby model", (Throwable)e);
        }
        catch (PartInitException e) {
            RailsUILog.logError((String)"Error creating editor", (Throwable)e);
        }
        catch (CoreException e) {
            RailsUILog.logError((String)"Error running action", (Throwable)e);
        }
    }

    private boolean attemptToOpenMvcView(IProject project, String path, String srcDir, String srcSuffix) throws RubyModelException, CoreException, PartInitException {
        TextSelection ts;
        Matcher m = Pattern.compile("^((?:.+?/)?)" + srcDir + "/(.+)" + srcSuffix + "\\.rb$").matcher(path);
        if (!m.matches()) {
            return false;
        }
        String appRootDir = String.valueOf(m.group(1).length() == 0 ? "" : "/") + m.group(1);
        String viewName = m.group(2);
        RubyEditor editor = (RubyEditor)this.getActiveEditor();
        RubyDocumentProvider provider = (RubyDocumentProvider)editor.getDocumentProvider();
        IRubyScript script = provider.getWorkingCopy((Object)editor.getEditorInput());
        String actionName = this.findAction(script, (ts = (TextSelection)editor.getSelectionProvider().getSelection()).getOffset());
        if (actionName == null) {
            IFile controller;
            IFile original;
            IRubyScript controllerScript = null;
            if (srcDir.equals(APP_MODELS)) {
                original = this.getCurrentFile();
                controller = RailsConventions.getControllerFromModel((IFile)original);
                controllerScript = RubyCore.create((IFile)controller);
                viewName = Inflector.pluralize((String)viewName);
            } else if (srcDir.equals(APP_HELPERS)) {
                original = this.getCurrentFile();
                controller = RailsConventions.getControllerFromHelper((IFile)original);
                controllerScript = RubyCore.create((IFile)controller);
            } else if (srcDir.equals("test/functional")) {
                original = this.getCurrentFile();
                controller = RailsConventions.getControllerFromFunctionalTest((IFile)original);
                controllerScript = RubyCore.create((IFile)controller);
            } else if (srcDir.equals("test/unit")) {
                original = this.getCurrentFile();
                controller = RailsConventions.getControllerFromUnitTest((IFile)original);
                controllerScript = RubyCore.create((IFile)controller);
                viewName = Inflector.pluralize((String)viewName);
            } else {
                controllerScript = script;
            }
            IType[] types = controllerScript.getTypes();
            WhichActionDialog dialog = new WhichActionDialog(Display.getDefault().getActiveShell(), types[0]);
            if (dialog.open() == 0) {
                actionName = dialog.getAction();
            }
        }
        if (actionName != null) {
            String filename;
            IFile fileHandle = this.findViewFile(project, appRootDir, viewName, actionName);
            if (!(fileHandle != null && fileHandle.exists() || (filename = ViewSelectionDialog.openConfirm(Display.getDefault().getActiveShell(), project, actionName)) == null)) {
                IPath filePath = project.getProjectRelativePath().append(String.valueOf(project.getName()) + appRootDir + "/app/views/" + viewName + "/" + filename);
                fileHandle = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                if (!fileHandle.getParent().exists()) {
                    try {
                        ((IFolder)fileHandle.getParent()).create(false, true, null);
                    }
                    catch (Exception exception) {}
                }
                ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.aptana.ide.editor.erb");
                String contents = store.getString("com.aptana.ide.editor.erb.ERBEDITOR_INITIAL_CONTENTS");
                fileHandle.create((InputStream)new ByteArrayInputStream(contents.getBytes()), false, null);
            }
            if (fileHandle != null && fileHandle.exists()) {
                FileEditorInput editorInput = new FileEditorInput(fileHandle);
                this.open((IEditorInput)editorInput, fileHandle);
            }
        }
        return true;
    }

    private IFile findViewFile(IProject project, String appRootDir, String viewName, String action) {
        int i = 0;
        while (i < VIEW_TYPES.length) {
            Path thePath = new Path(appRootDir);
            IFile fileHandle = project.getFile((IPath)(thePath = thePath.append("app").append("views").append(viewName).append(String.valueOf(action) + "." + VIEW_TYPES[i])));
            if (fileHandle.exists()) {
                return fileHandle;
            }
            ++i;
        }
        return null;
    }

    private boolean attemptToOpenMvcModelOrController(IProject project, String path, IFile original) throws PartInitException {
        String appRootDir = "";
        Matcher m = Pattern.compile("^(.+?/)(app/views/.+)$").matcher(path);
        if (m.matches()) {
            appRootDir = "/" + m.group(1);
            path = m.group(2);
        }
        if (path.startsWith("app/views")) {
            IPath tPath = original.getProjectRelativePath();
            String[] segments = tPath.segments();
            String patternStr = "app/views/(\\S+?)/" + segments[segments.length - 1];
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher("");
            matcher.reset(path);
            matcher.find();
            String controllername = matcher.group(1);
            IPath thepath = project.getProjectRelativePath().append(String.valueOf(project.getName()) + appRootDir + "/app/controllers/" + controllername + "_controller.rb");
            IFile fileHandle = ResourcesPlugin.getWorkspace().getRoot().getFile(thepath);
            IPath mailerpath = project.getProjectRelativePath().append(String.valueOf(project.getName()) + appRootDir + "/app/models/" + controllername + ".rb");
            IFile fileHandleMailer = ResourcesPlugin.getWorkspace().getRoot().getFile(mailerpath);
            if (fileHandle.exists()) {
                FileEditorInput editorInput = new FileEditorInput(fileHandle);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "org.rubypeople.rdt.ui.EditorRubyFile");
                return true;
            }
            if (fileHandleMailer.exists()) {
                FileEditorInput editorInput = new FileEditorInput(fileHandleMailer);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "org.rubypeople.rdt.ui.EditorRubyFile");
                return true;
            }
        }
        return false;
    }

    private void open(IEditorInput newEditorInput, IFile newFileHandle) throws PartInitException {
        if (this.shouldOpenInRHTMLEditor(newFileHandle)) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(newEditorInput, RHTML_EDITOR_ID);
            return;
        }
        if (this.shouldOpenInHAMLEditor(newFileHandle)) {
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor(HAML_EDITOR_ID);
            if (desc != null) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(newEditorInput, HAML_EDITOR_ID);
                return;
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(newEditorInput, RHTML_EDITOR_ID);
            return;
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(newEditorInput, "org.rubypeople.rdt.ui.EditorRubyFile");
    }

    private boolean shouldOpenInHAMLEditor(IFile fileHandle) {
        return fileHandle.getFileExtension().equals("haml");
    }

    private boolean shouldOpenInRHTMLEditor(IFile fileHandle) {
        return fileHandle.getFileExtension().equals("rhtml") || fileHandle.getFileExtension().equals("erb") || fileHandle.getFileExtension().equals("dryml");
    }

    public String findAction(IRubyScript script, int offset) throws RubyModelException {
        String retVal = null;
        IRubyElement method = this.findRubyMethod(script.getElementAt(offset));
        if (method != null) {
            retVal = method.getElementName();
        } else {
            IParent parent = (IParent)script.getChildren()[0];
            if (parent.hasChildren()) {
                IRubyElement[] child = parent.getChildren();
                int j = 0;
                while (j < child.length) {
                    if (child[j] instanceof RubyMethod) {
                        RubyMethod m = (RubyMethod)child[j];
                        int methodStart = m.getSourceRange().getOffset();
                        int methodEnd = m.getSourceRange().getOffset() + m.getSourceRange().getLength();
                        if (offset >= methodStart && offset <= methodEnd) {
                            retVal = m.getElementName();
                            break;
                        }
                    }
                    ++j;
                }
            }
        }
        return retVal;
    }

    private IRubyElement findRubyMethod(IRubyElement e) {
        if (this.isRubyMethod(e)) {
            return e;
        }
        if (e == null) {
            return null;
        }
        return this.findRubyMethod(e.getParent());
    }

    private boolean isRubyMethod(IRubyElement e) {
        boolean retVal = false;
        if (e instanceof RubyMethod) {
            retVal = true;
        }
        return retVal;
    }

    private class WhichActionDialog
    extends MessageDialog {
        private IType type;
        private Combo combo;
        private String action;

        protected WhichActionDialog(Shell parentShell, IType type) {
            super(parentShell, "Cursor not inside an action", null, "For which action?", 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.type = type;
        }

        protected Control createCustomArea(Composite parent) {
            try {
                IMethod[] methods = this.type.getMethods();
                if (methods == null || methods.length == 0) {
                    Label label = new Label(parent, 0);
                    label.setText("The current controller has no actions. Please create a public method in the controller first");
                } else {
                    this.combo = new Combo(parent, 4);
                    int i = 0;
                    while (i < methods.length) {
                        if (methods[i].getVisibility() == 1) {
                            this.combo.add(methods[i].getElementName());
                        }
                        ++i;
                    }
                    if (this.combo.getItemCount() > 0) {
                        this.combo.select(0);
                    }
                }
            }
            catch (RubyModelException e) {
                RailsUILog.log((CoreException)((Object)e));
            }
            return super.createCustomArea(parent);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0 && this.combo != null) {
                this.action = this.combo.getText();
            }
            super.buttonPressed(buttonId);
        }

        public String getAction() {
            return this.action;
        }
    }
}

