/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.actions;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.wizards.NewRailsProjectWizardAction;
import org.radrails.rails.ui.RailsUIPlugin;
import org.rubypeople.rdt.internal.ui.RubyExplorerTracker;

public class RailsProjectSelectionAction
extends Action
implements IMenuCreator {
    private Menu fMenu;
    private RubyExplorerTracker.IRubyProjectListener listener;

    public RailsProjectSelectionAction() {
        this("Select Rails Project");
    }

    public RailsProjectSelectionAction(String tooltip) {
        this.setEnabled(!RailsPlugin.getRailsProjects().isEmpty());
        this.setToolTipText(tooltip);
        this.setImageDescriptor(RailsUIPlugin.getImageDescriptor("icons/rails_project.png"));
        this.setMenuCreator(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResource source = event.getResource();
                if (source != null) {
                    return;
                }
                IResourceDelta[] deltas = event.getDelta().getAffectedChildren(7, 4);
                if (deltas != null && deltas.length > 0) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            if (RailsProjectSelectionAction.this.fMenu != null && !RailsProjectSelectionAction.this.fMenu.isDisposed()) {
                                RailsProjectSelectionAction.this.fMenu.dispose();
                            }
                            RailsProjectSelectionAction.this.fMenu = null;
                            RailsProjectSelectionAction.this.setEnabled(!RailsPlugin.getRailsProjects().isEmpty());
                        }
                    });
                }
            }
        }, 1);
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        int accel = 1;
        Set projects = RailsPlugin.getRailsProjects();
        for (IProject project : projects) {
            String label = project.getName();
            ImageDescriptor image = null;
            this.addActionToMenu(this.fMenu, new RailsProjectAction(label, image, project), accel);
            ++accel;
        }
        MenuItem addProjectItem = new MenuItem(this.fMenu, 8);
        addProjectItem.setText("Create new Rails project");
        addProjectItem.setImage(RailsUIPlugin.getImage("icons/newproj.gif"));
        addProjectItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new NewRailsProjectWizardAction().run();
            }
        });
        return this.fMenu;
    }

    private void addActionToMenu(Menu parent, Action action, int accelerator) {
        if (accelerator < 10) {
            StringBuffer label = new StringBuffer();
            label.append('&');
            label.append(accelerator);
            label.append(' ');
            label.append(action.getText());
            action.setText(label.toString());
        }
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public RubyExplorerTracker.IRubyProjectListener getListener() {
        return this.listener;
    }

    public void setListener(RubyExplorerTracker.IRubyProjectListener listener) {
        this.listener = listener;
    }

    private class RailsProjectAction
    extends Action {
        private IProject project;

        public RailsProjectAction(String label, ImageDescriptor image, IProject project) {
            this.setText(label);
            if (image != null) {
                this.setImageDescriptor(image);
            }
            this.project = project;
        }

        public void run() {
            if (RailsProjectSelectionAction.this.listener != null) {
                RailsProjectSelectionAction.this.listener.projectSelected(this.project);
            }
        }

        public void runWithEvent(Event event) {
            this.run();
        }
    }
}

