/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.radrails.rails.internal.ui.console.RailsShell;

public class RailsShellOpenJob
extends UIJob {
    private BundleContext context;

    public RailsShellOpenJob(BundleContext context) {
        super("Open Rails Shell");
        this.context = context;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (dw == null) {
            return Status.CANCEL_STATUS;
        }
        IWorkbenchPage page = dw.getActivePage();
        if (page == null) {
            return Status.CANCEL_STATUS;
        }
        IPerspectiveDescriptor desc = page.getPerspective();
        if (desc == null || desc.getId() == null) {
            return Status.CANCEL_STATUS;
        }
        if (!desc.getId().equals("org.radrails.db.ui.PerspectiveData") && !desc.getId().equals("org.radrails.rails.ui.PerspectiveRails")) {
            return Status.CANCEL_STATUS;
        }
        final RailsShell shell = RailsShell.open();
        if (this.javascriptConsoleWillAppear()) {
            IConsoleListener listener = new IConsoleListener(){

                public void consolesRemoved(IConsole[] consoles) {
                }

                public void consolesAdded(IConsole[] consoles) {
                    boolean addedJSConsole = false;
                    int i = 0;
                    while (i < consoles.length) {
                        if (RailsShellOpenJob.this.isJavascriptConsole(consoles[i])) {
                            addedJSConsole = true;
                            break;
                        }
                        ++i;
                    }
                    if (!addedJSConsole) {
                        return;
                    }
                    final 1 self = this;
                    UIJob job = new UIJob(""){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)shell);
                            ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener(self);
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                }
            };
            ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(listener);
        }
        return Status.OK_STATUS;
    }

    private boolean javascriptConsoleWillAppear() {
        if (this.javascriptConsoleAlreadyOpen()) {
            return false;
        }
        return this.javascriptConsoleBundleInstalled();
    }

    private boolean javascriptConsoleBundleInstalled() {
        Bundle[] bundles = this.context.getBundles();
        int i = 0;
        while (i < bundles.length) {
            String name = bundles[i].getSymbolicName();
            if (name.equals("org.eclipse.eclipsemonkey.lang.javascript")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean javascriptConsoleAlreadyOpen() {
        IConsole[] consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int i = 0;
        while (i < consoles.length) {
            if (this.isJavascriptConsole(consoles[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isJavascriptConsole(IConsole console) {
        String classname = console.getClass().getName();
        return classname.contains("JavaScriptConsole");
    }
}

