/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.radrails.db.core.DatabaseDescriptor;
import org.radrails.db.core.DatabaseLog;
import org.radrails.db.core.DatabaseManager;
import org.radrails.db.core.IDatabaseListener;
import org.radrails.db.core.ProjectDatabaseManager;
import org.radrails.rails.core.RailsLog;
import org.radrails.rails.internal.core.RailsPlugin;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBConfig;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SameDbNameException;
import zigen.plugin.db.core.SchemaInfo;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.ui.views.TreeContentProvider;
import zigen.plugin.db.ui.views.TreeView;

public class RailsDBConnector
implements IDatabaseListener {
    private static final String MYSQL_PLUGIN = "com.mysql.driver";

    public RailsDBConnector() {
        DatabaseManager.getInstance().addListener((IDatabaseListener)this);
        Job job = new Job("Add existing Rails project DB connections"){

            protected IStatus run(IProgressMonitor monitor) {
                Set projects = RailsPlugin.getRailsProjects();
                for (IProject project : projects) {
                    RailsDBConnector.this.projectAdded(project);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void addDB(DatabaseDescriptor databaseDescriptor) {
        try {
            IDBConfig existing = DBConfigManager.getDBConfig((String)RailsDBConnector.getConnectionName(databaseDescriptor));
            if (existing != null) {
                return;
            }
            final IDBConfig config = this.createNewConfig(databaseDescriptor);
            if (config == null) {
                return;
            }
            DBConfigManager.save((IDBConfig)config);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    TreeView tv = (TreeView)DbPlugin.findView((String)"zigen.plugin.db.ui.views.TreeView");
                    if (tv == null) {
                        return;
                    }
                    TreeContentProvider tcp = tv.getContentProvider();
                    tcp.addDataBase(config);
                    tv.getTreeViewer().refresh();
                }
            });
        }
        catch (SameDbNameException e) {
            RailsLog.log((String)e.getMessage());
        }
    }

    private static String getConnectionName(DatabaseDescriptor databaseDescriptor) {
        return String.valueOf(databaseDescriptor.getProject().getName()) + " (" + databaseDescriptor.getName() + ")";
    }

    private static void deleteConnection(final IDBConfig existing) {
        DBConfigManager.remove((IDBConfig)existing);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                TreeView tv = (TreeView)DbPlugin.findView((String)"zigen.plugin.db.ui.views.TreeView");
                if (tv == null) {
                    return;
                }
                TreeContentProvider tcp = tv.getContentProvider();
                tcp.removeDataBase(existing);
                tv.getTreeViewer().refresh();
            }
        });
    }

    protected IDBConfig createNewConfig(DatabaseDescriptor desc) {
        String driverPluginPath;
        DBConfig config;
        block4: {
            config = new DBConfig();
            config.setDbName(RailsDBConnector.getConnectionName(desc));
            driverPluginPath = this.getDriverPluginpath(this.getDriverPlugin(desc));
            if (driverPluginPath != null) break block4;
            return null;
        }
        try {
            String[] classpaths = new String[]{driverPluginPath};
            config.setClassPaths(classpaths);
            config.setDriverName(desc.getDriver());
            config.setUrl(desc.getUrl());
            config.setUserId(desc.getUsername());
            config.setSchema(desc.getUsername());
            config.setPassword(desc.getPassword());
            config.setJdbcType(4);
            config.setCharset("");
            config.setConvertUnicode(false);
            config.setAutoCommit(false);
            config.setOnlyDefaultSchema(false);
            config.setConnectAsSYSDBA(false);
            config.setConnectAsSYSOPER(false);
            String[] names = SchemaSearcher.execute((IDBConfig)config);
            SchemaInfo[] schemas = new SchemaInfo[names.length];
            int i = 0;
            while (i < names.length) {
                schemas[i] = new SchemaInfo((IDBConfig)config, names[i], true);
                ++i;
            }
            config.setDisplayedSchemas(schemas);
            config.setCheckFilterPattern(false);
            config.setFilterPattern("");
        }
        catch (Exception e) {
            DatabaseLog.log((Exception)e);
            return null;
        }
        return config;
    }

    private String getDriverPlugin(DatabaseDescriptor desc) {
        if (desc.isMySQL()) {
            return MYSQL_PLUGIN;
        }
        if (desc.isIBMDB2()) {
            return "com.ibmdb2.driver";
        }
        if (desc.isSQLite()) {
            return "org.sqlite.driver";
        }
        if (desc.isSQLServer()) {
            return "com.sqlserver.driver";
        }
        if (desc.isOracle()) {
            return "com.oracle.driver";
        }
        if (desc.isPostgresql()) {
            return "org.postgresql.driver";
        }
        return null;
    }

    private String getDriverPluginpath(String driverPlugin) throws IOException {
        if (driverPlugin == null) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)driverPlugin);
        if (bundle == null) {
            return null;
        }
        URL entry = bundle.getEntry("/");
        URL fileURL = FileLocator.toFileURL((URL)entry);
        String filePath = fileURL.getFile();
        if (Platform.getOS().equals("win32")) {
            filePath = filePath.substring(1);
        }
        return filePath;
    }

    public void projectAdded(IProject project) {
        ProjectDatabaseManager manager = DatabaseManager.getInstance().getProjectDatabaseManager(project);
        Collection descriptors = manager.getDatabaseDescriptors();
        for (final DatabaseDescriptor databaseDescriptor : descriptors) {
            Job job = new Job("Adding Rails project DB connection"){

                protected IStatus run(IProgressMonitor monitor) {
                    RailsDBConnector.this.addDB(databaseDescriptor);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    public void projectRemoved(IProject project) {
        RailsDBConnector.removeProjectDBConnections(project);
    }

    public static void removeProjectDBConnections(IProject project) {
        if (project == null) {
            return;
        }
        ProjectDatabaseManager manager = DatabaseManager.getInstance().getProjectDatabaseManager(project);
        if (manager == null) {
            return;
        }
        Collection descriptors = manager.getDatabaseDescriptors();
        for (final DatabaseDescriptor databaseDescriptor : descriptors) {
            Job job = new Job("Removing Rails project DB connection"){

                protected IStatus run(IProgressMonitor monitor) {
                    RailsDBConnector.removeDB(databaseDescriptor);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    private static void removeDB(DatabaseDescriptor databaseDescriptor) {
        IDBConfig existing = DBConfigManager.getDBConfig((String)RailsDBConnector.getConnectionName(databaseDescriptor));
        if (existing == null) {
            return;
        }
        RailsDBConnector.deleteConnection(existing);
    }

    public void stop() {
        DatabaseManager.getInstance().removeListener((IDatabaseListener)this);
    }

    public void databaseSettingsChanged(IProject project) {
        RailsDBConnector.removeProjectDBConnections(project);
        this.projectAdded(project);
    }
}

