/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.radrails.rails.internal.core.RailsPlugin;

public class RailsConsoleLine {
    protected String fFilename;
    protected int fLength;
    protected int fOffset;
    protected int fLineNumber;

    public String getFilename() {
        return this.fFilename;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public int getOffset() {
        return this.fOffset;
    }

    protected void makeRelativeToWorkspace(IProject launchedProject) {
        try {
            if (this.fFilename == null || this.fFilename.trim().length() == 0) {
                return;
            }
            String filename = this.fFilename;
            filename = this.fFilename.startsWith("./") ? this.fFilename.substring(1) : String.valueOf('/') + this.fFilename;
            IFile file = launchedProject.getFile(filename);
            if (!file.exists()) {
                IPath railsRoot = RailsPlugin.findRailsRoot((IProject)launchedProject);
                file = launchedProject.getFile(railsRoot.append(filename));
            }
            this.fFilename = file.getFullPath().toPortableString();
        }
        catch (RuntimeException runtimeException) {}
    }

    protected boolean isRelativePath() {
        if (this.fFilename.startsWith("./")) {
            return true;
        }
        int index = this.fFilename.indexOf(47);
        return index != -1 && !this.fFilename.startsWith("/") && this.fFilename.charAt(index - 1) != ':';
    }
}

