/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.corext.util.BusyIndicatorRunnableContext;
import org.rubypeople.rdt.internal.ui.wizards.IStatusChangeListener;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.rubypeople.rdt.ui.wizards.NewElementWizardPage;

public class RubyCapabilityConfigurationPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "RubyCapabilityConfigurationPage";
    private IRubyProject fRubyProject = null;
    private BuildPathsBlock fBuildPathsBlock;

    public RubyCapabilityConfigurationPage() {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.RubyCapabilityConfigurationPage_title);
        this.setDescription(NewWizardMessages.RubyCapabilityConfigurationPage_description);
    }

    private BuildPathsBlock getBuildPathsBlock() {
        if (this.fBuildPathsBlock == null) {
            IStatusChangeListener listener = new IStatusChangeListener(){

                public void statusChanged(IStatus status) {
                    RubyCapabilityConfigurationPage.this.updateStatus(status);
                }
            };
            this.fBuildPathsBlock = new BuildPathsBlock(new BusyIndicatorRunnableContext(), listener, 0, this.useNewSourcePage(), null);
        }
        return this.fBuildPathsBlock;
    }

    protected boolean useNewSourcePage() {
        return false;
    }

    public void init(IRubyProject jproject, IPath defaultOutputLocation, ILoadpathEntry[] defaultEntries, boolean defaultsOverrideExistingClasspath) {
        if (!defaultsOverrideExistingClasspath && jproject.exists() && jproject.getProject().getFile(".loadpath").exists()) {
            defaultOutputLocation = null;
            defaultEntries = null;
        }
        this.getBuildPathsBlock().init(jproject, defaultOutputLocation, defaultEntries);
        this.fRubyProject = jproject;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(1, false));
        Control control = this.getBuildPathsBlock().createControl(composite);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.rubypeople.rdt.ui.new_javaproject_wizard_page_context");
        this.setControl((Control)composite);
    }

    public ILoadpathEntry[] getRawClassPath() {
        return this.getBuildPathsBlock().getRawClassPath();
    }

    public IRubyProject getRubyProject() {
        return this.fRubyProject;
    }

    public IRunnableWithProgress getRunnable() {
        if (this.getRubyProject() != null) {
            return new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        RubyCapabilityConfigurationPage.this.configureRubyProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
        }
        return null;
    }

    public static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        RubyCapabilityConfigurationPage.createProject(project, locationPath != null ? URIUtil.toURI((IPath)locationPath) : null, monitor);
    }

    public static void createProject(IProject project, URI locationURI, IProgressMonitor monitor) throws CoreException {
        BuildPathsBlock.createProject(project, locationURI, monitor);
    }

    public void configureRubyProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int nSteps = 6;
        monitor.beginTask(NewWizardMessages.RubyCapabilityConfigurationPage_op_desc_ruby, nSteps);
        try {
            try {
                IProject project = this.getRubyProject().getProject();
                BuildPathsBlock.addRubyNature(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.getBuildPathsBlock().configureRubyProject((IProgressMonitor)new SubProgressMonitor(monitor, 5));
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }
}

