/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.rubypeople.rdt.internal.ui.wizards.TypedViewerFilter;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.rubypeople.rdt.ui.RubyElementLabelProvider;
import org.rubypeople.rdt.ui.RubyElementSorter;
import org.rubypeople.rdt.ui.StandardRubyElementContentProvider;
import org.rubypeople.rdt.ui.wizards.NewElementWizardPage;

public abstract class NewContainerWizardPage
extends NewElementWizardPage {
    protected static final String CONTAINER = "NewContainerWizardPage.container";
    protected IStatus fContainerStatus;
    private IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private StringButtonDialogField fContainerDialogField;
    private ISourceFolder fCurrSourceFolder;

    public NewContainerWizardPage(String name) {
        super(name);
        ContainerFieldAdapter adapter = new ContainerFieldAdapter();
        this.fContainerDialogField = new StringButtonDialogField(adapter);
        this.fContainerDialogField.setDialogFieldListener(adapter);
        this.fContainerDialogField.setLabelText(this.getContainerLabel());
        this.fContainerDialogField.setButtonLabel(NewWizardMessages.NewContainerWizardPage_container_button);
        this.fContainerStatus = new StatusInfo();
        this.fCurrSourceFolder = null;
    }

    protected IRubyElement getInitialRubyElement(IStructuredSelection selection) {
        IResource resource;
        IAdaptable adaptable;
        Object selectedElement;
        IRubyElement jelem = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable && (jelem = (IRubyElement)(adaptable = (IAdaptable)selectedElement).getAdapter(IRubyElement.class)) == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null && resource.getType() != 8) {
            while (jelem == null && resource.getType() != 4) {
                resource = resource.getParent();
                jelem = (IRubyElement)resource.getAdapter(IRubyElement.class);
            }
            if (jelem == null) {
                jelem = RubyCore.create((IResource)resource);
            }
        }
        if (jelem == null) {
            Object elem;
            IWorkbenchPart part = RubyPlugin.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = RubyPlugin.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IRubyElement) {
                jelem = (IRubyElement)elem;
            }
        }
        if (jelem == null || jelem.getElementType() == 0) {
            try {
                IRubyProject[] projects = RubyCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getRubyProjects();
                if (projects.length == 1) {
                    jelem = projects[0];
                }
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
        }
        return jelem;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.fWorkspaceRoot;
    }

    protected void createContainerControls(Composite parent, int nColumns) {
        this.fContainerDialogField.doFillIntoGrid(parent, nColumns);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    protected String getContainerLabel() {
        return NewWizardMessages.NewContainerWizardPage_container_label;
    }

    protected ITextSelection getCurrentTextSelection() {
        ISelection selection;
        ISelectionProvider selectionProvider;
        IWorkbenchPart part = RubyPlugin.getActivePage().getActivePart();
        if (part instanceof IEditorPart && (selectionProvider = part.getSite().getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    private void containerChangeControlPressed(DialogField field) {
        ISourceFolder root = this.chooseContainer();
        if (root != null) {
            this.setSourceFolder(root, true);
        }
    }

    public String getProjectText() {
        return this.fContainerDialogField.getText();
    }

    public String getSourceFolderText() {
        return this.fContainerDialogField.getText();
    }

    protected IStatus containerChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrSourceFolder = null;
        String str = this.getSourceFolderText();
        if (str.length() == 0) {
            status.setError(NewWizardMessages.NewContainerWizardPage_error_EnterContainerName);
            return status;
        }
        Path path = new Path(str);
        IResource res = this.fWorkspaceRoot.findMember((IPath)path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ProjectClosed, proj.getFullPath().toString()));
                    return status;
                }
                IRubyProject rproject = RubyCore.create((IProject)proj);
                IRubyElement element = RubyCore.create((IResource)res);
                this.fCurrSourceFolder = RubyModelUtil.getSourceFolder(element);
                if (res.exists()) {
                    try {
                        if (!proj.hasNature("org.rubypeople.rdt.core.rubynature")) {
                            if (resType == 4) {
                                status.setError(NewWizardMessages.NewContainerWizardPage_warning_NotARubyProject);
                            } else {
                                status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotInARubyProject);
                            }
                            return status;
                        }
                        if (!rproject.isOnLoadpath((IRubyElement)this.fCurrSourceFolder)) {
                            status.setWarning(Messages.format(NewWizardMessages.NewContainerWizardPage_warning_NotOnLoadPath, str));
                        }
                    }
                    catch (CoreException coreException) {
                        status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotARubyProject);
                    }
                }
                return status;
            }
            status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_NotAFolder, str));
            return status;
        }
        status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ContainerDoesNotExist, str));
        return status;
    }

    public void setSourceFolder(ISourceFolder root, boolean canBeModified) {
        this.fCurrSourceFolder = root;
        String str = root == null ? "" : root.getPath().makeRelative().toString();
        this.fContainerDialogField.setText(str);
        this.fContainerDialogField.setEnabled(canBeModified);
    }

    protected void initContainerPage(IRubyElement elem) {
        ISourceFolder initRoot = null;
        if (elem != null && !elem.isType(0)) {
            initRoot = RubyModelUtil.getSourceFolder(elem);
            try {
                IRubyProject rproject;
                if ((initRoot == null || ((ISourceFolderRoot)initRoot.getParent()).isExternal()) && (rproject = elem.getRubyProject()) != null) {
                    initRoot = null;
                    if (rproject.exists()) {
                        ISourceFolderRoot[] roots = rproject.getSourceFolderRoots();
                        int i = 0;
                        while (i < roots.length) {
                            if (!roots[i].isExternal()) {
                                initRoot = roots[i].getSourceFolder("");
                                break;
                            }
                            ++i;
                        }
                    }
                    if (initRoot == null) {
                        initRoot = rproject.getSourceFolderRoot(rproject.getResource()).getSourceFolder("");
                    }
                }
            }
            catch (RubyModelException e) {
                RubyCore.log((Exception)((Object)e));
            }
        }
        this.setSourceFolder(initRoot, true);
    }

    private void containerDialogFieldChanged(DialogField field) {
        if (field == this.fContainerDialogField) {
            this.fContainerStatus = this.containerChanged();
        }
        this.handleFieldChanged(CONTAINER);
    }

    protected void handleFieldChanged(String fieldName) {
    }

    protected ISourceFolder chooseContainer() {
        ISourceFolder initElement = this.getSourceFolder();
        Class[] acceptedClasses = new Class[]{IRubyProject.class, ISourceFolderRoot.class, ISourceFolder.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IRubyProject) {
                        IRubyProject jproject = (IRubyProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findSourceFolderRoot(path) != null;
                    }
                    if (element instanceof ISourceFolderRoot) {
                        return !((ISourceFolderRoot)element).isExternal();
                    }
                    return true;
                }
                catch (RubyModelException e) {
                    RubyPlugin.log(e.getStatus());
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IRubyModel.class, ISourceFolderRoot.class, IRubyProject.class, ISourceFolder.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof ISourceFolderRoot) {
                    return !((ISourceFolderRoot)element).isExternal();
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardRubyElementContentProvider provider = new StandardRubyElementContentProvider();
        RubyElementLabelProvider labelProvider = new RubyElementLabelProvider(RubyElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setSorter((ViewerSorter)new RubyElementSorter());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)RubyCore.create((IWorkspaceRoot)this.fWorkspaceRoot));
        dialog.setInitialSelection((Object)initElement);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IRubyProject) {
                IRubyProject jproject = (IRubyProject)element;
                return jproject.getSourceFolderRoot((IResource)jproject.getProject()).getSourceFolder("");
            }
            if (element instanceof ISourceFolderRoot) {
                return ((ISourceFolderRoot)element).getSourceFolder("");
            }
            if (element instanceof ISourceFolder) {
                return (ISourceFolder)element;
            }
            return null;
        }
        return null;
    }

    public ISourceFolder getSourceFolder() {
        return this.fCurrSourceFolder;
    }

    private class ContainerFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private ContainerFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            NewContainerWizardPage.this.containerChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            NewContainerWizardPage.this.containerDialogFieldChanged(field);
        }
    }
}

