/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.TypedViewerFilter;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.EditVariableEntryDialog;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.MultipleFolderSelectionDialog;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.NewVariableEntryDialog;

public final class BuildPathDialogAccess {
    private BuildPathDialogAccess() {
    }

    public static IPath[] chooseSourceFolderEntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        String title = NewWizardMessages.BuildPathDialogAccess_ExistingSourceFolderDialog_new_title;
        String message = NewWizardMessages.BuildPathDialogAccess_ExistingSourceFolderDialog_new_description;
        return BuildPathDialogAccess.internalChooseFolderEntry(shell, initialSelection, usedEntries, title, message);
    }

    private static IPath[] internalChooseFolderEntry(Shell shell, IPath initialSelection, IPath[] usedEntries, String title, String message) {
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        ArrayList<IResource> usedContainers = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource = root.findMember(usedEntries[i]);
            if (resource instanceof IContainer) {
                usedContainers.add(resource);
            }
            ++i;
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        Object[] used = usedContainers.toArray();
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setExisting(used);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setHelpAvailable(false);
        dialog.addFilter(new TypedViewerFilter(acceptedClasses, used));
        dialog.setInput(root);
        dialog.setInitialFocus(focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = elem.getFullPath();
                ++i2;
            }
            return res;
        }
        return null;
    }

    public static IPath[] chooseExternalFolderEntries(Shell shell) {
        String lastUsedPath = RubyPlugin.getDefault().getDialogSettings().get("org.rubypeople.rdt.ui.lastextjar");
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        DirectoryDialog dialog = new DirectoryDialog(shell, 2);
        dialog.setText(NewWizardMessages.BuildPathDialogAccess_ExtJARArchiveDialog_new_title);
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        dialog.getText();
        IPath filterPath = Path.fromOSString((String)dialog.getFilterPath());
        IPath[] elems = new IPath[]{filterPath};
        RubyPlugin.getDefault().getDialogSettings().put("org.rubypeople.rdt.ui.lastextjar", dialog.getFilterPath());
        return elems;
    }

    public static IPath configureExternalFolderEntry(Shell shell, IPath initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        String lastUsedPath = initialEntry.removeLastSegments(1).toOSString();
        DirectoryDialog dialog = new DirectoryDialog(shell, 4);
        dialog.setText(NewWizardMessages.BuildPathDialogAccess_ExtJARArchiveDialog_edit_title);
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        RubyPlugin.getDefault().getDialogSettings().put("org.rubypeople.rdt.ui.lastextjar", dialog.getFilterPath());
        return Path.fromOSString((String)res).makeAbsolute();
    }

    public static IPath[] chooseVariableEntries(Shell shell, IPath[] existingPaths) {
        if (existingPaths == null) {
            throw new IllegalArgumentException();
        }
        NewVariableEntryDialog dialog = new NewVariableEntryDialog(shell);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public static IPath configureVariableEntry(Shell shell, IPath initialEntryPath, IPath[] existingPaths) {
        if (existingPaths == null) {
            throw new IllegalArgumentException();
        }
        EditVariableEntryDialog dialog = new EditVariableEntryDialog(shell, initialEntryPath, existingPaths);
        if (dialog.open() == 0) {
            return dialog.getPath();
        }
        return null;
    }
}

