/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.search.SearchMessages;
import org.rubypeople.rdt.internal.ui.search.SearchUtil;
import org.rubypeople.rdt.ui.actions.FindAction;
import org.rubypeople.rdt.ui.actions.FindReadReferencesAction;
import org.rubypeople.rdt.ui.actions.FindReadReferencesInProjectAction;
import org.rubypeople.rdt.ui.actions.FindReadReferencesInWorkingSetAction;
import org.rubypeople.rdt.ui.actions.SelectionDispatchAction;
import org.rubypeople.rdt.ui.actions.WorkingSetFindAction;

public class ReadReferencesSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_readReferences;
    private IWorkbenchSite fSite;
    private RubyEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindReadReferencesAction fFindReadReferencesAction;
    private FindReadReferencesInProjectAction fFindReadReferencesInProjectAction;
    private FindReadReferencesInWorkingSetAction fFindReadReferencesInWorkingSetAction;

    public ReadReferencesSearchGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.fFindReadReferencesAction = new FindReadReferencesAction(site);
        this.fFindReadReferencesAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.read.access.in.workspace");
        this.fFindReadReferencesInProjectAction = new FindReadReferencesInProjectAction(site);
        this.fFindReadReferencesInProjectAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.read.access.in.project");
        this.fFindReadReferencesInWorkingSetAction = new FindReadReferencesInWorkingSetAction(site);
        this.fFindReadReferencesInWorkingSetAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.read.access.in.working.set");
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.registerAction(this.fFindReadReferencesAction, provider, selection);
        this.registerAction(this.fFindReadReferencesInProjectAction, provider, selection);
        this.registerAction(this.fFindReadReferencesInWorkingSetAction, provider, selection);
    }

    public ReadReferencesSearchGroup(RubyEditor editor) {
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindReadReferencesAction = new FindReadReferencesAction(this.fEditor);
        this.fFindReadReferencesAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.read.access.in.workspace");
        this.fEditor.setAction("SearchReadAccessInWorkspace", (IAction)this.fFindReadReferencesAction);
        this.fFindReadReferencesInProjectAction = new FindReadReferencesInProjectAction(this.fEditor);
        this.fFindReadReferencesInProjectAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.read.access.in.project");
        this.fEditor.setAction("SearchReadAccessInProject", (IAction)this.fFindReadReferencesInProjectAction);
        this.fFindReadReferencesInWorkingSetAction = new FindReadReferencesInWorkingSetAction(this.fEditor);
        this.fFindReadReferencesInWorkingSetAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.read.access.in.working.set");
        this.fEditor.setAction("SearchReadAccessInWorkingSet", (IAction)this.fFindReadReferencesInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    private void addAction(IAction action, IMenuManager manager) {
        if (action.isEnabled()) {
            manager.add(action);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] workingSets, IMenuManager manager) {
        WorkingSetFindAction action = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindReadReferencesInWorkingSetAction(this.fEditor, workingSets), SearchUtil.toString(workingSets)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindReadReferencesInWorkingSetAction(this.fSite, workingSets), SearchUtil.toString(workingSets));
        action.update(this.getContext().getSelection());
        this.addAction((IAction)action, manager);
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager javaSearchMM = new MenuManager(MENU_TEXT, "group.search");
        this.addAction((IAction)this.fFindReadReferencesAction, (IMenuManager)javaSearchMM);
        this.addAction((IAction)this.fFindReadReferencesInProjectAction, (IMenuManager)javaSearchMM);
        javaSearchMM.add((IContributionItem)new Separator());
        Iterator iter = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iter.hasNext()) {
            this.addWorkingSetAction((IWorkingSet[])iter.next(), (IMenuManager)javaSearchMM);
        }
        this.addAction((IAction)this.fFindReadReferencesInWorkingSetAction, (IMenuManager)javaSearchMM);
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fFindReadReferencesAction, provider);
            this.disposeAction(this.fFindReadReferencesInProjectAction, provider);
            this.disposeAction(this.fFindReadReferencesInWorkingSetAction, provider);
        }
        this.fFindReadReferencesAction = null;
        this.fFindReadReferencesInProjectAction = null;
        this.fFindReadReferencesInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.rubypeople.rdt.ui.actions.ReadAccessInWorkspace", (IAction)this.fFindReadReferencesAction);
            this.fActionBars.setGlobalActionHandler("org.rubypeople.rdt.ui.actions.ReadAccessInProject", (IAction)this.fFindReadReferencesInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.rubypeople.rdt.ui.actions.ReadAccessInWorkingSet", (IAction)this.fFindReadReferencesInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

