/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionGroup;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.actions.ActionMessages;
import org.rubypeople.rdt.internal.ui.viewsupport.MemberFilter;
import org.rubypeople.rdt.internal.ui.viewsupport.MemberFilterAction;
import org.rubypeople.rdt.ui.PreferenceConstants;

public class MemberFilterActionGroup
extends ActionGroup {
    public static final int FILTER_NONPUBLIC = 1;
    public static final int FILTER_STATIC = 2;
    public static final int FILTER_FIELDS = 4;
    public static final int FILTER_LOCALTYPES = 8;
    public static final int ALL_FILTERS = 15;
    private static final String TAG_HIDEFIELDS = "hidefields";
    private static final String TAG_HIDESTATIC = "hidestatic";
    private static final String TAG_HIDENONPUBLIC = "hidenonpublic";
    private static final String TAG_HIDELOCALTYPES = "hidelocaltypes";
    private MemberFilterAction[] fFilterActions;
    private MemberFilter fFilter;
    private StructuredViewer fViewer;
    private String fViewerId;
    private boolean fInViewMenu;

    public MemberFilterActionGroup(StructuredViewer viewer, String viewerId) {
        this(viewer, viewerId, false);
    }

    public MemberFilterActionGroup(StructuredViewer viewer, String viewerId, boolean inViewMenu) {
        this(viewer, viewerId, inViewMenu, 15);
    }

    public MemberFilterActionGroup(StructuredViewer viewer, String viewerId, boolean inViewMenu, int availableFilters) {
        String helpContext;
        String title;
        boolean filterEnabled;
        this.fViewer = viewer;
        this.fViewerId = viewerId;
        this.fInViewMenu = inViewMenu;
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        this.fFilter = new MemberFilter();
        ArrayList<MemberFilterAction> actions = new ArrayList<MemberFilterAction>(4);
        int filterProperty = 4;
        if (this.isSet(filterProperty, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.MemberFilterActionGroup_hide_fields_label;
            helpContext = "org.rubypeople.rdt.ui.filter_fields_action";
            MemberFilterAction hideFields = new MemberFilterAction(this, title, filterProperty, helpContext, filterEnabled);
            hideFields.setDescription(ActionMessages.MemberFilterActionGroup_hide_fields_description);
            hideFields.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_fields_tooltip);
            RubyPluginImages.setLocalImageDescriptors((IAction)hideFields, "fields_co.gif");
            actions.add(hideFields);
        }
        if (this.isSet(filterProperty = 2, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.MemberFilterActionGroup_hide_static_label;
            helpContext = "org.rubypeople.rdt.ui.filter_static_action";
            MemberFilterAction hideStatic = new MemberFilterAction(this, title, 2, helpContext, filterEnabled);
            hideStatic.setDescription(ActionMessages.MemberFilterActionGroup_hide_static_description);
            hideStatic.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_static_tooltip);
            RubyPluginImages.setLocalImageDescriptors((IAction)hideStatic, "static_co.gif");
            actions.add(hideStatic);
        }
        if (this.isSet(filterProperty = 1, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.MemberFilterActionGroup_hide_nonpublic_label;
            helpContext = "org.rubypeople.rdt.ui.filter_public_action";
            MemberFilterAction hideNonPublic = new MemberFilterAction(this, title, filterProperty, helpContext, filterEnabled);
            hideNonPublic.setDescription(ActionMessages.MemberFilterActionGroup_hide_nonpublic_description);
            hideNonPublic.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_nonpublic_tooltip);
            RubyPluginImages.setLocalImageDescriptors((IAction)hideNonPublic, "public_co.gif");
            actions.add(hideNonPublic);
        }
        if (this.isSet(filterProperty = 8, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.MemberFilterActionGroup_hide_localtypes_label;
            helpContext = "org.rubypeople.rdt.ui.filter_localtypes_action";
            MemberFilterAction hideLocalTypes = new MemberFilterAction(this, title, filterProperty, helpContext, filterEnabled);
            hideLocalTypes.setDescription(ActionMessages.MemberFilterActionGroup_hide_localtypes_description);
            hideLocalTypes.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_localtypes_tooltip);
            RubyPluginImages.setLocalImageDescriptors((IAction)hideLocalTypes, "localtypes_co.gif");
            actions.add(hideLocalTypes);
        }
        this.fFilterActions = actions.toArray(new MemberFilterAction[actions.size()]);
        this.fViewer.addFilter((ViewerFilter)this.fFilter);
    }

    private String getPreferenceKey(int filterProperty) {
        return "MemberFilterActionGroup." + this.fViewerId + '.' + String.valueOf(filterProperty);
    }

    public void setMemberFilter(int filterProperty, boolean set) {
        this.setMemberFilters(new int[]{filterProperty}, new boolean[]{set}, true);
    }

    private void setMemberFilters(int[] propertyKeys, boolean[] propertyValues, boolean refresh) {
        if (propertyKeys.length == 0) {
            return;
        }
        Assert.isTrue((propertyKeys.length == propertyValues.length ? 1 : 0) != 0);
        int i = 0;
        while (i < propertyKeys.length) {
            int filterProperty = propertyKeys[i];
            boolean set = propertyValues[i];
            IPreferenceStore store = RubyPlugin.getDefault().getPreferenceStore();
            boolean found = false;
            int j = 0;
            while (j < this.fFilterActions.length) {
                int currProperty = this.fFilterActions[j].getFilterProperty();
                if (currProperty == filterProperty) {
                    this.fFilterActions[j].setChecked(set);
                    found = true;
                    store.setValue(this.getPreferenceKey(filterProperty), set);
                }
                ++j;
            }
            if (found) {
                if (set) {
                    this.fFilter.addFilter(filterProperty);
                } else {
                    this.fFilter.removeFilter(filterProperty);
                }
            }
            ++i;
        }
        if (refresh) {
            this.fViewer.getControl().setRedraw(false);
            BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    MemberFilterActionGroup.this.fViewer.refresh();
                }
            });
            this.fViewer.getControl().setRedraw(true);
        }
    }

    private boolean isSet(int flag, int set) {
        return (flag & set) != 0;
    }

    public boolean hasMemberFilter(int filterProperty) {
        return this.fFilter.hasFilter(filterProperty);
    }

    public void saveState(IMemento memento) {
        memento.putString(TAG_HIDEFIELDS, String.valueOf(this.hasMemberFilter(4)));
        memento.putString(TAG_HIDESTATIC, String.valueOf(this.hasMemberFilter(2)));
        memento.putString(TAG_HIDENONPUBLIC, String.valueOf(this.hasMemberFilter(1)));
        memento.putString(TAG_HIDELOCALTYPES, String.valueOf(this.hasMemberFilter(8)));
    }

    public void restoreState(IMemento memento) {
        this.setMemberFilters(new int[]{4, 2, 1, 8}, new boolean[]{Boolean.valueOf(memento.getString(TAG_HIDEFIELDS)), Boolean.valueOf(memento.getString(TAG_HIDESTATIC)), Boolean.valueOf(memento.getString(TAG_HIDENONPUBLIC)), Boolean.valueOf(memento.getString(TAG_HIDELOCALTYPES))}, false);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.contributeToToolBar(actionBars.getToolBarManager());
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        if (this.fInViewMenu) {
            return;
        }
        int i = 0;
        while (i < this.fFilterActions.length) {
            tbm.add((IAction)this.fFilterActions[i]);
            ++i;
        }
    }

    public void contributeToViewMenu(IMenuManager menu) {
        if (!this.fInViewMenu) {
            return;
        }
        if (menu.find("filters") != null) {
            int i = 0;
            while (i < this.fFilterActions.length) {
                menu.prependToGroup("filters", (IAction)this.fFilterActions[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.fFilterActions.length) {
                menu.add((IAction)this.fFilterActions[i]);
                ++i;
            }
        }
    }

    public void dispose() {
        super.dispose();
    }
}

