/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.ActionUtil;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyScriptEditorInput;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.search.FindOccurrencesEngine;
import org.rubypeople.rdt.internal.ui.search.OccurrencesFinder;
import org.rubypeople.rdt.internal.ui.search.SearchMessages;
import org.rubypeople.rdt.ui.actions.SelectionDispatchAction;

public class FindOccurrencesInFileAction
extends SelectionDispatchAction {
    private RubyEditor fEditor;
    private IActionBars fActionBars;

    public FindOccurrencesInFileAction(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    public FindOccurrencesInFileAction(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public FindOccurrencesInFileAction(RubyEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(FindOccurrencesInFileAction.getEditorInput(editor) != null);
    }

    public FindOccurrencesInFileAction(IWorkbenchSite site) {
        super(site);
        if (site instanceof IViewSite) {
            this.fActionBars = ((IViewSite)site).getActionBars();
        } else if (site instanceof IEditorSite) {
            this.fActionBars = ((IEditorSite)site).getActionBars();
        } else if (site instanceof IPageSite) {
            this.fActionBars = ((IPageSite)site).getActionBars();
        }
        this.setText(SearchMessages.Search_FindOccurrencesInFile_label);
        this.setToolTipText(SearchMessages.Search_FindOccurrencesInFile_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.find_occurrences_in_file_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.getMember(selection) != null);
    }

    private IMember getMember(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IMember) {
            IMember member = (IMember)o;
            try {
                if (member.getNameRange() == null) {
                    return null;
                }
            }
            catch (RubyModelException rubyModelException) {
                return null;
            }
            return member;
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        IMember member = this.getMember(selection);
        if (!ActionUtil.isProcessable(this.getShell(), member)) {
            return;
        }
        FindOccurrencesEngine engine = FindOccurrencesEngine.create((IRubyElement)member, new OccurrencesFinder());
        try {
            ISourceRange range = member.getNameRange();
            String result = engine.run(range.getOffset(), range.getLength());
            if (result != null) {
                FindOccurrencesInFileAction.showMessage(this.getShell(), this.fActionBars, result);
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
    }

    private static void showMessage(Shell shell, IActionBars actionBars, String msg) {
        IStatusLineManager statusLine;
        if (actionBars != null && (statusLine = actionBars.getStatusLineManager()) != null) {
            statusLine.setMessage(msg);
        }
        shell.getDisplay().beep();
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public final void run(ITextSelection ts) {
        IRubyElement input = FindOccurrencesInFileAction.getEditorInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        FindOccurrencesEngine engine = FindOccurrencesEngine.create(input, new OccurrencesFinder());
        try {
            String result = engine.run(ts.getOffset(), ts.getLength());
            if (result != null) {
                FindOccurrencesInFileAction.showMessage(this.getShell(), this.fEditor, result);
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
    }

    private static IRubyElement getEditorInput(RubyEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IRubyScriptEditorInput) {
            return ((IRubyScriptEditorInput)input).getRubyScript();
        }
        return RubyPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input);
    }

    private static void showMessage(Shell shell, RubyEditor editor, String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, msg, null);
        }
        shell.getDisplay().beep();
    }
}

