/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.search.RubySearchScopeFactory;
import org.rubypeople.rdt.internal.ui.search.SearchMessages;
import org.rubypeople.rdt.internal.ui.search.SearchUtil;
import org.rubypeople.rdt.ui.actions.FindDeclarationsAction;
import org.rubypeople.rdt.ui.search.ElementQuerySpecification;
import org.rubypeople.rdt.ui.search.QuerySpecification;

public class FindDeclarationsInWorkingSetAction
extends FindDeclarationsAction {
    private IWorkingSet[] fWorkingSet;

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite site) {
        this(site, (IWorkingSet[])null);
    }

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite site, IWorkingSet[] workingSets) {
        super(site);
        this.fWorkingSet = workingSets;
    }

    public FindDeclarationsInWorkingSetAction(RubyEditor editor) {
        this(editor, null);
    }

    public FindDeclarationsInWorkingSetAction(RubyEditor editor, IWorkingSet[] workingSets) {
        super(editor);
        this.fWorkingSet = workingSets;
    }

    void init() {
        this.setText(SearchMessages.Search_FindDeclarationsInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindDeclarationsInWorkingSetAction_tooltip);
        this.setImageDescriptor(RubyPluginImages.DESC_OBJS_SEARCH_DECL);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.find_declarations_in_working_set_action");
    }

    QuerySpecification createQuery(IRubyElement element) throws RubyModelException {
        RubySearchScopeFactory factory = RubySearchScopeFactory.getInstance();
        IWorkingSet[] workingSets = this.fWorkingSet;
        if (this.fWorkingSet == null && (workingSets = factory.queryWorkingSets()) == null) {
            return null;
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        IRubySearchScope scope = factory.createRubySearchScope(workingSets, true);
        String description = factory.getWorkingSetScopeDescription(workingSets, true);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

