/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.progress.IProgressService;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.ActionUtil;
import org.rubypeople.rdt.internal.ui.actions.OpenActionUtil;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.search.RubySearchQuery;
import org.rubypeople.rdt.internal.ui.search.RubySearchScopeFactory;
import org.rubypeople.rdt.internal.ui.search.SearchMessages;
import org.rubypeople.rdt.internal.ui.search.SearchUtil;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.ui.RubyElementLabelProvider;
import org.rubypeople.rdt.ui.actions.SelectionDispatchAction;
import org.rubypeople.rdt.ui.search.ElementQuerySpecification;
import org.rubypeople.rdt.ui.search.QuerySpecification;

public abstract class FindAction
extends SelectionDispatchAction {
    private static final IRubyElement RETURN_WITHOUT_BEEP = RubyCore.create((IWorkspaceRoot)RubyPlugin.getWorkspace().getRoot());
    private Class[] fValidTypes = this.getValidTypes();
    private RubyEditor fEditor;

    FindAction(IWorkbenchSite site) {
        super(site);
        this.init();
    }

    FindAction(RubyEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn((IEditorPart)this.fEditor));
    }

    abstract void init();

    abstract Class[] getValidTypes();

    private boolean canOperateOn(IStructuredSelection sel) {
        return sel != null && !sel.isEmpty() && this.canOperateOn(this.getRubyElement(sel, true));
    }

    boolean canOperateOn(IRubyElement element) {
        if (element == null || this.fValidTypes == null || this.fValidTypes.length == 0 || !ActionUtil.isOnBuildPath(element)) {
            return false;
        }
        int i = 0;
        while (i < this.fValidTypes.length) {
            if (this.fValidTypes[i].isInstance(element)) {
                if (element.getElementType() == 3) {
                    return this.hasChildren((ISourceFolder)element);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasChildren(ISourceFolder packageFragment) {
        try {
            return packageFragment.hasChildren();
        }
        catch (RubyModelException rubyModelException) {
            return false;
        }
    }

    private IRubyElement getTypeIfPossible(IRubyElement o, boolean silent) {
        switch (o.getElementType()) {
            case 4: {
                if (silent) {
                    return o;
                }
                return this.findType((IRubyScript)o, silent);
            }
        }
        return o;
    }

    IRubyElement getRubyElement(IStructuredSelection selection, boolean silent) {
        if (selection.size() == 1) {
            Object firstElement = selection.getFirstElement();
            IRubyElement elem = null;
            if (firstElement instanceof IRubyElement) {
                elem = (IRubyElement)firstElement;
            } else if (firstElement instanceof IAdaptable) {
                elem = (IRubyElement)((IAdaptable)firstElement).getAdapter(IRubyElement.class);
            }
            if (elem != null) {
                return this.getTypeIfPossible(elem, silent);
            }
        }
        return null;
    }

    private void showOperationUnavailableDialog() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)SearchMessages.RubyElementAction_operationUnavailable_title, (String)this.getOperationUnavailableMessage());
    }

    String getOperationUnavailableMessage() {
        return SearchMessages.RubyElementAction_operationUnavailable_generic;
    }

    private IRubyElement findType(IRubyScript cu, boolean silent) {
        Object[] types = null;
        try {
            types = cu.getAllTypes();
        }
        catch (RubyModelException ex) {
            if (RubyModelUtil.isExceptionToBeLogged((CoreException)((Object)ex))) {
                ExceptionHandler.log(ex, SearchMessages.RubyElementAction_error_open_message);
            }
            if (silent) {
                return RETURN_WITHOUT_BEEP;
            }
            return null;
        }
        if (types.length == 1 || silent && types.length > 0) {
            return types[0];
        }
        if (silent) {
            return RETURN_WITHOUT_BEEP;
        }
        if (types.length == 0) {
            return null;
        }
        String title = SearchMessages.RubyElementAction_typeSelectionDialog_title;
        String message = SearchMessages.RubyElementAction_typeSelectionDialog_message;
        int flags = RubyElementLabelProvider.SHOW_DEFAULT;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new RubyElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements(types);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return RETURN_WITHOUT_BEEP;
    }

    public void run(IStructuredSelection selection) {
        IRubyElement element = this.getRubyElement(selection, false);
        if (element == null || !element.exists()) {
            this.showOperationUnavailableDialog();
            return;
        }
        if (element == RETURN_WITHOUT_BEEP) {
            return;
        }
        this.run(element);
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), (IEditorPart)this.fEditor)) {
            return;
        }
        try {
            String title = SearchMessages.SearchElementSelectionDialog_title;
            String message = SearchMessages.SearchElementSelectionDialog_message;
            IRubyElement[] elements = SelectionConverter.codeResolveForked(this.fEditor, true);
            if (elements.length > 0 && this.canOperateOn(elements[0])) {
                IRubyElement element = elements[0];
                if (elements.length > 1) {
                    element = OpenActionUtil.selectRubyElement(elements, this.getShell(), title, message);
                }
                if (element != null) {
                    this.run(element);
                }
            } else {
                this.showOperationUnavailableDialog();
            }
        }
        catch (InvocationTargetException ex) {
            String title = SearchMessages.Search_Error_search_title;
            String message = SearchMessages.Search_Error_codeResolve;
            ExceptionHandler.handle(ex, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canOperateOn(selection));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void run(IRubyElement element) {
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        try {
            this.performNewSearch(element);
        }
        catch (RubyModelException ex) {
            ExceptionHandler.handle((CoreException)((Object)ex), this.getShell(), SearchMessages.Search_Error_search_notsuccessful_title, SearchMessages.Search_Error_search_notsuccessful_message);
        }
    }

    private void performNewSearch(IRubyElement element) throws RubyModelException {
        RubySearchQuery query = new RubySearchQuery(this.createQuery(element));
        if (query.canRunInBackground()) {
            SearchUtil.runQueryInBackground(query);
        } else {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            IStatus status = SearchUtil.runQueryInForeground((IRunnableContext)progressService, query);
            if (status.matches(7)) {
                ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.Search_Error_search_title, (String)SearchMessages.Search_Error_search_message, (IStatus)status);
            }
        }
    }

    QuerySpecification createQuery(IRubyElement element) throws RubyModelException {
        RubySearchScopeFactory factory = RubySearchScopeFactory.getInstance();
        IRubySearchScope scope = factory.createWorkspaceScope(true);
        String description = factory.getWorkspaceScopeDescription(true);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }

    abstract int getLimitTo();

    IType getType(IRubyElement element) {
        if (element == null) {
            return null;
        }
        IType type = null;
        if (element.getElementType() == 5) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        }
        return type;
    }

    RubyEditor getEditor() {
        return this.fEditor;
    }
}

