/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.search.SearchMessages;
import org.rubypeople.rdt.internal.ui.search.SearchUtil;
import org.rubypeople.rdt.ui.actions.FindAction;
import org.rubypeople.rdt.ui.actions.FindDeclarationsAction;
import org.rubypeople.rdt.ui.actions.FindDeclarationsInProjectAction;
import org.rubypeople.rdt.ui.actions.FindDeclarationsInWorkingSetAction;
import org.rubypeople.rdt.ui.actions.SelectionDispatchAction;
import org.rubypeople.rdt.ui.actions.WorkingSetFindAction;

public class DeclarationsSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_declarations;
    private IWorkbenchSite fSite;
    private RubyEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindDeclarationsAction fFindDeclarationsAction;
    private FindDeclarationsInProjectAction fFindDeclarationsInProjectAction;
    private FindDeclarationsInWorkingSetAction fFindDeclarationsInWorkingSetAction;

    public DeclarationsSearchGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.fFindDeclarationsAction = new FindDeclarationsAction(site);
        this.fFindDeclarationsAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.declarations.in.workspace");
        this.fFindDeclarationsInProjectAction = new FindDeclarationsInProjectAction(site);
        this.fFindDeclarationsInProjectAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.declarations.in.project");
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(site);
        this.fFindDeclarationsInWorkingSetAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.declarations.in.working.set");
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.registerAction(this.fFindDeclarationsAction, provider, selection);
        this.registerAction(this.fFindDeclarationsInProjectAction, provider, selection);
        this.registerAction(this.fFindDeclarationsInWorkingSetAction, provider, selection);
    }

    public DeclarationsSearchGroup(RubyEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindDeclarationsAction = new FindDeclarationsAction(this.fEditor);
        this.fFindDeclarationsAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.declarations.in.workspace");
        this.fEditor.setAction("SearchDeclarationsInWorkspace", (IAction)this.fFindDeclarationsAction);
        this.fFindDeclarationsInProjectAction = new FindDeclarationsInProjectAction(this.fEditor);
        this.fFindDeclarationsInProjectAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.declarations.in.project");
        this.fEditor.setAction("SearchDeclarationsInProjects", (IAction)this.fFindDeclarationsInProjectAction);
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(this.fEditor);
        this.fFindDeclarationsInWorkingSetAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.declarations.in.working.set");
        this.fEditor.setAction("SearchDeclarationsInWorkingSet", (IAction)this.fFindDeclarationsInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    private void addAction(IAction action, IMenuManager manager) {
        if (action.isEnabled()) {
            manager.add(action);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] workingSets, IMenuManager manager) {
        WorkingSetFindAction action = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindDeclarationsInWorkingSetAction(this.fEditor, workingSets), SearchUtil.toString(workingSets)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindDeclarationsInWorkingSetAction(this.fSite, workingSets), SearchUtil.toString(workingSets));
        action.update(this.getContext().getSelection());
        this.addAction((IAction)action, manager);
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager javaSearchMM = new MenuManager(MENU_TEXT, "group.search");
        this.addAction((IAction)this.fFindDeclarationsAction, (IMenuManager)javaSearchMM);
        this.addAction((IAction)this.fFindDeclarationsInProjectAction, (IMenuManager)javaSearchMM);
        javaSearchMM.add((IContributionItem)new Separator());
        Iterator iter = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iter.hasNext()) {
            this.addWorkingSetAction((IWorkingSet[])iter.next(), (IMenuManager)javaSearchMM);
        }
        this.addAction((IAction)this.fFindDeclarationsInWorkingSetAction, (IMenuManager)javaSearchMM);
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fFindDeclarationsAction, provider);
            this.disposeAction(this.fFindDeclarationsInProjectAction, provider);
            this.disposeAction(this.fFindDeclarationsInWorkingSetAction, provider);
        }
        this.fFindDeclarationsAction = null;
        this.fFindDeclarationsInProjectAction = null;
        this.fFindDeclarationsInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.rubypeople.rdt.ui.actions.DeclarationsInWorkspace", (IAction)this.fFindDeclarationsAction);
            this.fActionBars.setGlobalActionHandler("org.rubypeople.rdt.ui.actions.DeclarationsInProject", (IAction)this.fFindDeclarationsInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.rubypeople.rdt.ui.actions.DeclarationsInWorkingSet", (IAction)this.fFindDeclarationsInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

