/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.navigator.ResourceNavigatorRenameAction;
import org.rubypeople.rdt.ui.IPackagesViewPart;
import org.rubypeople.rdt.ui.actions.CopyAction;
import org.rubypeople.rdt.ui.actions.PasteAction;

public class CCPActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private Clipboard fClipboard;
    private SelectionListenerAction[] fActions;
    private SelectionListenerAction fDeleteAction;
    private SelectionListenerAction fCopyAction;
    private RenameResourceAction fRenameAction;
    private PasteAction fPasteAction;
    private MoveResourceAction fMoveAction;
    private TreeViewer fTreeViewer;

    public CCPActionGroup(IViewPart part) {
        if (part instanceof IPackagesViewPart) {
            IPackagesViewPart pack = (IPackagesViewPart)part;
            this.fTreeViewer = pack.getTreeViewer();
        }
        this.init((IWorkbenchSite)part.getSite());
    }

    public CCPActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    private CCPActionGroup(IWorkbenchSite site) {
        this.init(site);
    }

    private void init(IWorkbenchSite site) {
        this.fSite = site;
        this.fClipboard = new Clipboard(site.getShell().getDisplay());
        this.fPasteAction = new PasteAction(this.fSite.getShell(), this.fClipboard);
        this.fPasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.fCopyAction = new CopyAction(this.fSite.getShell(), this.fClipboard, this.fPasteAction);
        this.fCopyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.fMoveAction = new MoveResourceAction(this.fSite.getShell());
        this.fRenameAction = this.fTreeViewer != null ? new ResourceNavigatorRenameAction(this.fSite.getShell(), this.fTreeViewer) : new RenameResourceAction(this.fSite.getShell());
        this.fRenameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
        this.fDeleteAction = new DeleteResourceAction(this.fSite.getShell());
        this.fDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.fActions = new SelectionListenerAction[]{this.fCopyAction, this.fPasteAction, this.fDeleteAction, this.fRenameAction, this.fMoveAction};
        this.registerActionsAsSelectionChangeListeners();
    }

    private void registerActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.getSelection();
        int i = 0;
        while (i < this.fActions.length) {
            SelectionListenerAction action = this.fActions[i];
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
            ++i;
        }
    }

    private void deregisterActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        int i = 0;
        while (i < this.fActions.length) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fActions[i]);
            ++i;
        }
    }

    public IAction getDeleteAction() {
        return this.fDeleteAction;
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fDeleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.fPasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.fMoveAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        int i = 0;
        while (i < this.fActions.length) {
            SelectionListenerAction action = this.fActions[i];
            menu.appendToGroup("group.edit", (IAction)action);
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
        this.deregisterActionsAsSelectionChangeListeners();
    }
}

