/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableViewerSorter
extends ViewerSorter {
    private int columnIndex = 0;

    public TableViewerSorter(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int order = 0;
        if (viewer instanceof TableViewer) {
            TableViewer tv = (TableViewer)viewer;
            Table table = tv.getTable();
            table.setSortColumn(table.getColumn(this.columnIndex));
            int idx1 = -1;
            int idx2 = -1;
            int i = 0;
            while (i < table.getItemCount()) {
                Object obj = tv.getElementAt(i);
                if (obj.equals(e1)) {
                    idx1 = i;
                } else if (obj.equals(e2)) {
                    idx2 = i;
                }
                if (idx1 > 0 && idx2 > 0) break;
                ++i;
            }
            if (idx1 > -1 && idx2 > -1) {
                String str1 = table.getItems()[idx1].getText(this.columnIndex);
                String str2 = table.getItems()[idx2].getText(this.columnIndex);
                order = str1.compareTo(str2);
                try {
                    Double d1 = Double.valueOf(str1);
                    Double d2 = Double.valueOf(str2);
                    order = d1.compareTo(d2);
                }
                catch (NumberFormatException numberFormatException) {}
                if (table.getSortDirection() != 128) {
                    order *= -1;
                }
            }
        }
        return order;
    }

    public static void bind(final TableViewer tableViewer) {
        final Table table = tableViewer.getTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            final int columnNum = i;
            TableColumn column = table.getColumn(i);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableViewerSorter sorter = new TableViewerSorter(columnNum);
                    if (table.getSortDirection() == 128) {
                        table.setSortDirection(1024);
                    } else if (table.getSortDirection() == 1024) {
                        table.setSortDirection(128);
                    } else {
                        table.setSortDirection(128);
                    }
                    tableViewer.setSorter((ViewerSorter)sorter);
                }
            });
            ++i;
        }
    }

    public static void bind(TableViewer tableViewer, int columnIndex) {
        TableViewerSorter.bind(tableViewer);
        TableViewerSorter sorter = new TableViewerSorter(columnIndex);
        tableViewer.setSorter((ViewerSorter)sorter);
    }
}

