/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyBlock;

public class StandardRubyElementContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers;
    protected boolean fProvideWorkingCopy;

    public StandardRubyElementContentProvider() {
        this(false);
    }

    public StandardRubyElementContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        this(provideMembers);
    }

    public StandardRubyElementContentProvider(boolean provideMembers) {
        this.fProvideMembers = provideMembers;
        this.fProvideWorkingCopy = provideMembers;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean b) {
        this.fProvideMembers = b;
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public void setProvideWorkingCopy(boolean b) {
        this.fProvideWorkingCopy = b;
    }

    public boolean providesWorkingCopies() {
        return this.getProvideWorkingCopy();
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            if (element instanceof IRubyModel) {
                return this.getRubyProjects((IRubyModel)element);
            }
            if (element instanceof IRubyProject) {
                return this.getSourceFolderRoots((IRubyProject)element);
            }
            if (element instanceof ISourceFolderRoot) {
                return this.getSourceFolders((ISourceFolderRoot)element);
            }
            if (element instanceof ISourceFolder) {
                return this.getFoldersAndRubyScripts((ISourceFolder)element);
            }
            if (element instanceof IFolder) {
                return this.getResources((IFolder)element);
            }
            if (this.getProvideMembers() && element instanceof ISourceReference && element instanceof IParent) {
                return this.removeBlocks(((IParent)element).getChildren());
            }
        }
        catch (RubyModelException rubyModelException) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    protected Object[] removeBlocks(Object[] members) {
        ArrayList<Object> tempResult = new ArrayList<Object>(members.length);
        int i = 0;
        while (i < members.length) {
            if (!(members[i] instanceof RubyBlock)) {
                tempResult.add(members[i]);
            }
            ++i;
        }
        return tempResult.toArray();
    }

    private Object[] getSourceFolders(ISourceFolderRoot root) throws RubyModelException {
        Object[] fragments = root.getChildren();
        ArrayList<ISourceFolder> list = new ArrayList<ISourceFolder>();
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i] instanceof ISourceFolder) {
                ISourceFolder folder = (ISourceFolder)fragments[i];
                if (folder.isDefaultPackage()) {
                    list.addAll((Collection)Arrays.asList(folder.getRubyScripts()));
                } else {
                    String name = folder.getElementName();
                    int index = name.indexOf(File.separatorChar);
                    if (index == -1) {
                        list.add(folder);
                    }
                }
            }
            ++i;
        }
        fragments = new IRubyElement[list.size()];
        fragments = list.toArray(fragments);
        Object[] nonRubyResources = root.getNonRubyResources();
        if (nonRubyResources == null) {
            return fragments;
        }
        return StandardRubyElementContentProvider.concatenate(fragments, nonRubyResources);
    }

    private Object[] getSourceFolderRoots(IRubyProject project) throws RubyModelException {
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        ISourceFolderRoot[] roots = project.getSourceFolderRoots();
        ArrayList<Object> list = new ArrayList<Object>(roots.length);
        int i = 0;
        while (i < roots.length) {
            ISourceFolderRoot root = roots[i];
            if (this.isProjectSourceFolderRoot(root)) {
                Object[] children = this.getChildren(root);
                int k = 0;
                while (k < children.length) {
                    list.add(children[k]);
                    ++k;
                }
            } else if (this.hasChildren(root)) {
                list.add(root);
            }
            ++i;
        }
        return StandardRubyElementContentProvider.concatenate(list.toArray(), project.getNonRubyResources());
    }

    protected boolean isProjectSourceFolderRoot(ISourceFolderRoot root) {
        IResource resource = root.getResource();
        return resource instanceof IProject;
    }

    private Object[] getFoldersAndRubyScripts(ISourceFolder folder) throws RubyModelException {
        ISourceFolderRoot root = (ISourceFolderRoot)folder.getParent();
        IRubyElement[] children = root.getChildren();
        ArrayList<IRubyElement> list = new ArrayList<IRubyElement>();
        int i = 0;
        while (i < children.length) {
            if (!children[i].equals(folder) && children[i].getElementName().startsWith(folder.getElementName())) {
                String name = children[i].getElementName();
                int index = (name = name.substring(folder.getElementName().length() + 1)).indexOf(File.separator);
                if (index == -1) {
                    list.add(children[i]);
                }
            }
            ++i;
        }
        Object[] folders = new IRubyElement[list.size()];
        folders = list.toArray(folders);
        return StandardRubyElementContentProvider.concatenate(folders, StandardRubyElementContentProvider.concatenate(folder.getRubyScripts(), folder.getNonRubyResources()));
    }

    public boolean hasChildren(Object element) {
        Object[] children;
        IRubyProject jp;
        if (this.getProvideMembers()) {
            if (element instanceof IRubyScript) {
                return true;
            }
        } else if (element instanceof IRubyScript || element instanceof IFile) {
            return false;
        }
        if (element instanceof IRubyProject && !(jp = (IRubyProject)element).getProject().isOpen()) {
            return false;
        }
        if (element instanceof IParent) {
            try {
                if (((IParent)element).hasChildren()) {
                    return true;
                }
            }
            catch (RubyModelException rubyModelException) {
                return true;
            }
        }
        return (children = this.getChildren(element)) != null && children.length > 0;
    }

    public Object getParent(Object element) {
        if (!this.exists(element)) {
            return null;
        }
        return this.internalGetParent(element);
    }

    protected Object[] getRubyProjects(IRubyModel jm) throws RubyModelException {
        return jm.getRubyProjects();
    }

    private Object[] getResources(IFolder folder) {
        try {
            Object[] members = folder.members();
            IRubyProject javaProject = RubyCore.create((IProject)folder.getProject());
            if (javaProject == null || !javaProject.exists()) {
                return members;
            }
            boolean isFolderOnClasspath = true;
            ArrayList nonRubyResources = new ArrayList();
            int i = 0;
            while (i < members.length) {
                Object cfr_ignored_0 = members[i];
                ++i;
            }
            return nonRubyResources.toArray();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    protected boolean isClassPathChange(IRubyElementDelta delta) {
        return false;
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof IRubyElement) {
            return ((IRubyElement)element).exists();
        }
        return true;
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IRubyElement jParent = RubyCore.create((IResource)parent);
            if (jParent != null && jParent.exists()) {
                return jParent;
            }
            return parent;
        }
        if (element instanceof IRubyElement) {
            IRubyElement parent = ((IRubyElement)element).getParent();
            return parent;
        }
        return null;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }

    protected Object skipProjectSourceFolderRoot(ISourceFolderRoot root) {
        if (this.isProjectSourceFolderRoot(root)) {
            return root.getParent();
        }
        return root;
    }

    protected boolean isSourceFolderEmpty(IRubyElement element) throws RubyModelException {
        ISourceFolder fragment;
        return element instanceof ISourceFolder && (fragment = (ISourceFolder)element).exists() && !fragment.hasChildren() && fragment.getNonRubyResources().length <= 0 && fragment.hasSubfolders();
    }
}

