/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui;

import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyElementImageProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.StorageLabelProvider;
import org.rubypeople.rdt.ui.RubyElementLabels;

public class RubyElementLabelProvider
extends LabelProvider {
    public static final int SHOW_OVERLAY_ICONS = 2;
    public static final int SHOW_ROOT = 4;
    public static final int SHOW_SMALL_ICONS = 8;
    public static final int SHOW_VARIABLE = 16;
    public static final int SHOW_QUALIFIED = 32;
    public static final int SHOW_POST_QUALIFIED = 64;
    public static final int SHOW_BASICS = 0;
    public static final int SHOW_DEFAULT = new Integer(2);
    private RubyElementImageProvider fImageLabelProvider = new RubyElementImageProvider();
    private StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private int fFlags;
    private int fImageFlags;
    private long fTextFlags;

    public RubyElementLabelProvider() {
        this(SHOW_DEFAULT);
    }

    public RubyElementLabelProvider(int flags) {
        this.fFlags = flags;
        this.updateImageProviderFlags();
        this.updateTextProviderFlags();
    }

    private boolean getFlag(int flag) {
        return (this.fFlags & flag) != 0;
    }

    public void turnOn(int flags) {
        this.fFlags |= flags;
        this.updateImageProviderFlags();
        this.updateTextProviderFlags();
    }

    public void turnOff(int flags) {
        this.fFlags &= ~flags;
        this.updateImageProviderFlags();
        this.updateTextProviderFlags();
    }

    private void updateImageProviderFlags() {
        this.fImageFlags = 0;
        if (this.getFlag(2)) {
            this.fImageFlags |= 1;
        }
        if (this.getFlag(8)) {
            this.fImageFlags |= 2;
        }
    }

    private void updateTextProviderFlags() {
        this.fTextFlags = 2L;
        if (this.getFlag(4)) {
            this.fTextFlags |= 0x80000000000L;
        }
        if (this.getFlag(16)) {
            this.fTextFlags |= 0x10000000000L;
        }
        if (this.getFlag(32)) {
            this.fTextFlags |= 0x89050480L;
        }
        if (this.getFlag(64)) {
            this.fTextFlags |= 0x112120900L;
        }
    }

    public Image getImage(Object element) {
        Image result = this.fImageLabelProvider.getImageLabel(element, this.fImageFlags);
        if (result != null) {
            return result;
        }
        if (element instanceof IStorage) {
            return this.fStorageLabelProvider.getImage(element);
        }
        return result;
    }

    public String getText(Object element) {
        String text = RubyElementLabels.getTextLabel(element, this.fTextFlags);
        if (text.length() > 0) {
            return text;
        }
        if (element instanceof IStorage) {
            return this.fStorageLabelProvider.getText(element);
        }
        return text;
    }

    public void dispose() {
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }
}

