/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.viewsupport.IProblemChangedListener;
import org.rubypeople.rdt.ui.RubyElementImageDescriptor;
import org.rubypeople.rdt.ui.viewsupport.ImageDescriptorRegistry;
import org.rubypeople.rdt.ui.viewsupport.ImageImageDescriptor;

public class ProblemsLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private static final int ERRORTICK_WARNING = 32;
    private static final int ERRORTICK_ERROR = 64;
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;
    private IProblemChangedListener fProblemChangedListener;
    private ListenerList fListeners;
    private ISourceRange fCachedRange;

    public ProblemsLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public ProblemsLabelDecorator(ImageDescriptorRegistry registry) {
        this.fRegistry = registry;
        this.fProblemChangedListener = null;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : RubyPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object obj) {
        int adornmentFlags = this.computeAdornmentFlags(obj);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new RubyElementImageDescriptor(baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
        }
        return image;
    }

    protected int computeAdornmentFlags(Object obj) {
        block12: {
            try {
                if (obj instanceof IRubyElement) {
                    IRubyElement element = (IRubyElement)obj;
                    int type = element.getElementType();
                    switch (type) {
                        case 0: 
                        case 1: 
                        case 2: {
                            return this.getErrorTicksFromMarkers(element.getResource(), 2, null);
                        }
                        case 3: 
                        case 4: {
                            return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                        }
                        case 5: 
                        case 6: 
                        case 8: 
                        case 12: 
                        case 15: 
                        case 16: {
                            IRubyScript cu = (IRubyScript)element.getAncestor(4);
                            if (cu != null) {
                                ISourceReference ref = type == 4 ? null : (ISourceReference)element;
                                IAnnotationModel model = this.isInRubyAnnotationModel(cu);
                                int result = 0;
                                result = model != null ? this.getErrorTicksFromAnnotationModel(model, ref) : this.getErrorTicksFromMarkers(cu.getResource(), 1, ref);
                                this.fCachedRange = null;
                                return result;
                            }
                            break block12;
                        }
                    }
                    break block12;
                }
                if (obj instanceof IResource) {
                    return this.getErrorTicksFromMarkers((IResource)obj, 2, null);
                }
            }
            catch (CoreException e) {
                if (e instanceof RubyModelException && ((RubyModelException)((Object)e)).isDoesNotExist()) {
                    return 0;
                }
                if (e.getStatus().getCode() == 376) {
                    return 0;
                }
                RubyPlugin.log(e);
            }
        }
        return 0;
    }

    private int getErrorTicksFromMarkers(IResource res, int depth, ISourceReference sourceElement) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return 0;
        }
        int info = 0;
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        if (markers != null) {
            int i = 0;
            while (i < markers.length && info != 64) {
                IMarker curr = markers[i];
                if (sourceElement == null || this.isMarkerInRange(curr, sourceElement)) {
                    int priority = curr.getAttribute("severity", -1);
                    if (priority == 1) {
                        info = 32;
                    } else if (priority == 2) {
                        info = 64;
                    }
                }
                ++i;
            }
        }
        return info;
    }

    private boolean isMarkerInRange(IMarker marker, ISourceReference sourceElement) throws CoreException {
        if (marker.isSubtypeOf("org.eclipse.core.resources.textmarker")) {
            int pos = marker.getAttribute("charStart", -1);
            return this.isInside(pos, sourceElement);
        }
        return false;
    }

    private IAnnotationModel isInRubyAnnotationModel(IRubyScript original) {
        if (original.isWorkingCopy()) {
            FileEditorInput editorInput = new FileEditorInput((IFile)original.getResource());
            return RubyPlugin.getDefault().getRubyDocumentProvider().getAnnotationModel(editorInput);
        }
        return null;
    }

    private int getErrorTicksFromAnnotationModel(IAnnotationModel model, ISourceReference sourceElement) throws CoreException {
        int info = 0;
        Iterator iter = model.getAnnotationIterator();
        while (info != 64 && iter.hasNext()) {
            Annotation annot = (Annotation)iter.next();
            IMarker marker = this.isAnnotationInRange(model, annot, sourceElement);
            if (marker == null) continue;
            int priority = marker.getAttribute("severity", -1);
            if (priority == 1) {
                info = 32;
                continue;
            }
            if (priority != 2) continue;
            info = 64;
        }
        return info;
    }

    private IMarker isAnnotationInRange(IAnnotationModel model, Annotation annot, ISourceReference sourceElement) throws CoreException {
        IMarker marker;
        if (annot instanceof MarkerAnnotation && (sourceElement == null || this.isInside(model.getPosition(annot), sourceElement)) && (marker = ((MarkerAnnotation)annot).getMarker()).exists() && marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            return marker;
        }
        return null;
    }

    private boolean isInside(Position pos, ISourceReference sourceElement) throws CoreException {
        return pos != null && this.isInside(pos.getOffset(), sourceElement);
    }

    protected boolean isInside(int pos, ISourceReference sourceElement) throws CoreException {
        ISourceRange range;
        if (this.fCachedRange == null) {
            this.fCachedRange = sourceElement.getSourceRange();
        }
        if ((range = this.fCachedRange) != null) {
            int rangeOffset = range.getOffset();
            return rangeOffset <= pos && rangeOffset + range.getLength() > pos;
        }
        return false;
    }

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            RubyPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
            this.fProblemChangedListener = null;
        }
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
        if (this.fProblemChangedListener == null) {
            this.fProblemChangedListener = new IProblemChangedListener(){

                public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
                    ProblemsLabelDecorator.this.fireProblemsChanged(changedResources, isMarkerChange);
                }
            };
            RubyPlugin.getDefault().getProblemMarkerManager().addListener(this.fProblemChangedListener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
            if (this.fListeners.isEmpty() && this.fProblemChangedListener != null) {
                RubyPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
                this.fProblemChangedListener = null;
            }
        }
    }

    private void fireProblemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent event = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, changedResources, isMarkerChange);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged((LabelProviderChangedEvent)event);
                ++i;
            }
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags == 64) {
            decoration.addOverlay(RubyPluginImages.DESC_OVR_ERROR);
        } else if (adornmentFlags == 32) {
            decoration.addOverlay(RubyPluginImages.DESC_OVR_WARNING);
        }
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private static final long serialVersionUID = 1L;
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider eventSource, IResource[] changedResource, boolean isMarkerChange) {
            super(eventSource, (Object[])changedResource);
            this.fMarkerChange = isMarkerChange;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

