/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.MethodOverrideTester;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.corext.util.SuperTypeHierarchyCache;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.ui.RubyElementImageDescriptor;
import org.rubypeople.rdt.ui.viewsupport.ImageDescriptorRegistry;
import org.rubypeople.rdt.ui.viewsupport.ImageImageDescriptor;

public class OverrideIndicatorLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;

    public OverrideIndicatorLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public OverrideIndicatorLabelDecorator(ImageDescriptorRegistry registry) {
        this.fRegistry = registry;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : RubyPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object element) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new RubyElementImageDescriptor(baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
        }
        return image;
    }

    public int computeAdornmentFlags(Object element) {
        block6: {
            if (element instanceof IMethod) {
                IMethod method;
                block5: {
                    method = (IMethod)element;
                    if (method.getRubyProject().isOnLoadpath((IRubyElement)method)) break block5;
                    return 0;
                }
                try {
                    if (!method.isConstructor() && method.getVisibility() != 2 && !method.isSingleton()) {
                        int res = this.getOverrideIndicators(method);
                        return res;
                    }
                }
                catch (RubyModelException e) {
                    if (e.isDoesNotExist()) break block6;
                    RubyPlugin.log(e);
                }
            }
        }
        return 0;
    }

    protected int getOverrideIndicators(IMethod method) throws RubyModelException {
        IType type = method.getDeclaringType();
        if (type == null) {
            return 0;
        }
        MethodOverrideTester methodOverrideTester = SuperTypeHierarchyCache.getMethodOverrideTester(type);
        IMethod defining = methodOverrideTester.findOverriddenMethod(method, true);
        if (defining != null) {
            return 128;
        }
        return 0;
    }

    protected int findInHierarchy(IType type, ITypeHierarchy hierarchy, String name, String[] paramTypes) throws RubyModelException {
        IMethod res;
        IType superClass = hierarchy.getSuperclass(type);
        if (superClass != null && (res = RubyModelUtil.findMethodInHierarchy(hierarchy, superClass, name, paramTypes, false)) != null && res.getVisibility() != 2 && RubyModelUtil.isVisibleInHierarchy((IMember)res, type.getSourceFolder())) {
            return 128;
        }
        IType[] interfaces = hierarchy.getSuperModules(type);
        int i = 0;
        while (i < interfaces.length) {
            IMethod res2 = RubyModelUtil.findMethodInHierarchy(hierarchy, interfaces[i], name, paramTypes, false);
            if (res2 != null) {
                return 128;
            }
            ++i;
        }
        return 0;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if ((adornmentFlags & 0x100) != 0) {
            decoration.addOverlay(RubyPluginImages.DESC_OVR_IMPLEMENTS);
        } else if ((adornmentFlags & 0x80) != 0) {
            decoration.addOverlay(RubyPluginImages.DESC_OVR_OVERRIDES);
        }
    }
}

