/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.preferences.ScrolledPageContent;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.internal.ui.util.ViewerPane;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorer;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.HintTextGroup;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ListDialogField;

public class NewSourceContainerWorkbookPage
extends BuildPathBasePage
implements LoadpathModifier.ILoadpathModifierListener {
    public static final String OPEN_SETTING = "org.rubypeople.rdt.internal.ui.wizards.buildpaths.NewSourceContainerPage.openSetting";
    private ListDialogField fClassPathList;
    private HintTextGroup fHintTextGroup;
    private DialogPackageExplorer fPackageExplorer;
    private final BuildPathsBlock fBuildPathsBlock;
    private IRubyProject fRubyProject;

    public NewSourceContainerWorkbookPage(ListDialogField classPathList, IRunnableContext context, BuildPathsBlock buildPathsBlock) {
        this.fClassPathList = classPathList;
        this.fBuildPathsBlock = buildPathsBlock;
        this.fPackageExplorer = new DialogPackageExplorer();
        this.fHintTextGroup = new HintTextGroup(this.fPackageExplorer, context, this);
    }

    public void init(IRubyProject javaProject) {
        this.fRubyProject = javaProject;
        this.fHintTextGroup.setRubyProject(javaProject);
        this.fPackageExplorer.setInput(javaProject);
    }

    public Control getControl(Composite parent) {
        final int[] sashWeight = new int[]{60};
        final IPreferenceStore preferenceStore = RubyPlugin.getDefault().getPreferenceStore();
        preferenceStore.setDefault(OPEN_SETTING, true);
        ScrolledPageContent scrolledContent = new ScrolledPageContent(parent);
        Composite body = scrolledContent.getBody();
        body.setLayout((Layout)new GridLayout());
        final SashForm sashForm = new SashForm(body, 512);
        sashForm.setFont(sashForm.getFont());
        ViewerPane pane = new ViewerPane((Composite)sashForm, 0x800800);
        pane.setContent(this.fPackageExplorer.createControl((Composite)pane));
        this.fPackageExplorer.setContentProvider();
        final ExpandableComposite excomposite = new ExpandableComposite((Composite)sashForm, 0, 18);
        excomposite.setFont(sashForm.getFont());
        excomposite.setText(NewWizardMessages.NewSourceContainerWorkbookPage_HintTextGroup_title);
        boolean isExpanded = preferenceStore.getBoolean(OPEN_SETTING);
        excomposite.setExpanded(isExpanded);
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledPageContent parentScrolledComposite = NewSourceContainerWorkbookPage.this.getParentScrolledComposite((Control)excomposite);
                if (parentScrolledComposite != null) {
                    boolean expanded = excomposite.isExpanded();
                    parentScrolledComposite.reflow(true);
                    NewSourceContainerWorkbookPage.this.adjustSashForm(sashWeight, sashForm, expanded);
                    preferenceStore.setValue(NewSourceContainerWorkbookPage.OPEN_SETTING, expanded);
                }
            }
        });
        excomposite.setClient((Control)this.fHintTextGroup.createControl((Composite)excomposite));
        DialogPackageExplorerActionGroup actionGroup = new DialogPackageExplorerActionGroup(this.fHintTextGroup, this);
        ToolBarManager tbm = actionGroup.createLeftToolBarManager(pane);
        pane.setTopCenter(null);
        pane.setTopLeft((Control)tbm.getControl());
        tbm = actionGroup.createLeftToolBar(pane);
        pane.setTopRight((Control)tbm.getControl());
        this.fHintTextGroup.setActionGroup(actionGroup);
        this.fPackageExplorer.setActionGroup(actionGroup);
        actionGroup.addListener(this.fHintTextGroup);
        sashForm.setWeights(new int[]{60, 40});
        this.adjustSashForm(sashWeight, sashForm, excomposite.isExpanded());
        GridData gd = new GridData(1808);
        PixelConverter converter = new PixelConverter((Control)parent);
        gd.heightHint = converter.convertHeightInCharsToPixels(20);
        sashForm.setLayoutData((Object)gd);
        parent.layout(true);
        return scrolledContent;
    }

    private void adjustSashForm(int[] sashWeight, SashForm sashForm, boolean isExpanded) {
        if (isExpanded) {
            int upperWeight = sashWeight[0];
            sashForm.setWeights(new int[]{upperWeight, 100 - upperWeight});
        } else {
            sashWeight[0] = sashForm.getWeights()[0] / 10;
            sashForm.setWeights(new int[]{95, 5});
        }
        sashForm.layout(true);
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent)) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    private Shell getShell() {
        return RubyPlugin.getActiveWorkbenchShell();
    }

    public List getSelection() {
        ArrayList<CPListElement> selectedList = new ArrayList<CPListElement>();
        IRubyProject project = this.fHintTextGroup.getRubyProject();
        try {
            List list = this.fHintTextGroup.getSelection().toList();
            List existingEntries = LoadpathModifier.getExistingEntries(project);
            int i = 0;
            while (i < list.size()) {
                ILoadpathEntry entry;
                CPListElement cpElement;
                Object obj = list.get(i);
                if (obj instanceof ISourceFolderRoot) {
                    ISourceFolderRoot element = (ISourceFolderRoot)obj;
                    cpElement = LoadpathModifier.getLoadpathEntry(existingEntries, element);
                    selectedList.add(cpElement);
                } else if (obj instanceof IRubyProject && (entry = LoadpathModifier.getLoadpathEntryFor(project.getPath(), project, 3)) != null) {
                    cpElement = CPListElement.createFromExisting(entry, project);
                    selectedList.add(cpElement);
                }
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {
            return new ArrayList();
        }
        return selectedList;
    }

    public void setSelection(List selection, boolean expand) {
        if (selection.size() == 0) {
            return;
        }
        ArrayList<CPListElement> cpEntries = new ArrayList<CPListElement>();
        int i = 0;
        while (i < selection.size()) {
            CPListElementAttribute attribute;
            CPListElement element;
            Object obj = selection.get(i);
            if (obj instanceof CPListElement) {
                CPListElement element2 = (CPListElement)obj;
                if (element2.getEntryKind() == 3) {
                    cpEntries.add(element2);
                }
            } else if (obj instanceof CPListElementAttribute && (element = (attribute = (CPListElementAttribute)obj).getParent()).getEntryKind() == 3) {
                cpEntries.add(element);
            }
            ++i;
        }
        List list = this.fClassPathList.getElements();
        ILoadpathEntry[] entries = new ILoadpathEntry[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            CPListElement entry = (CPListElement)list.get(i2);
            entries[i2] = entry.getLoadpathEntry();
            ++i2;
        }
        try {
            this.fRubyProject.setRawLoadpath(entries, null);
            this.fPackageExplorer.refresh();
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
        this.fPackageExplorer.setSelection(cpEntries);
    }

    public boolean isEntryKind(int kind) {
        return kind == 3;
    }

    public void classpathEntryChanged(List newEntries) {
        this.fClassPathList.setElements(newEntries);
    }
}

