/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.ExclusionInclusionDialog;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.LinkFolderDialog;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.RemoveLinkedFolderDialog;

public class LoadpathModifierQueries {
    public static IInclusionExclusionQuery getDefaultInclusionExclusionQuery(final Shell shell) {
        return new IInclusionExclusionQuery(){
            protected IPath[] fInclusionPattern;
            protected IPath[] fExclusionPattern;

            public boolean doQuery(final CPListElement element, final boolean focusOnExcluded) {
                final boolean[] result = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Shell sh = shell != null ? shell : RubyPlugin.getActiveWorkbenchShell();
                        ExclusionInclusionDialog dialog = new ExclusionInclusionDialog(sh, element, focusOnExcluded);
                        result[0] = dialog.open() == 0;
                        fInclusionPattern = dialog.getInclusionPattern();
                        fExclusionPattern = dialog.getExclusionPattern();
                    }
                });
                return result[0];
            }

            public IPath[] getInclusionPattern() {
                return this.fInclusionPattern;
            }

            public IPath[] getExclusionPattern() {
                return this.fExclusionPattern;
            }
        };
    }

    public static ILinkToQuery getDefaultLinkQuery(final Shell shell, final IRubyProject project, IPath desiredOutputLocation) {
        return new ILinkToQuery(){
            protected IFolder fFolder;

            public boolean doQuery() {
                final boolean[] isOK = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Shell sh = shell != null ? shell : RubyPlugin.getActiveWorkbenchShell();
                        LinkFolderDialog dialog = new LinkFolderDialog(sh, (IContainer)project.getProject());
                        boolean bl = isOK[0] = dialog.open() == 0;
                        if (isOK[0]) {
                            fFolder = dialog.getCreatedFolder();
                        }
                    }
                });
                return isOK[0];
            }

            public IFolder getCreatedFolder() {
                return this.fFolder;
            }
        };
    }

    public static IRemoveLinkedFolderQuery getDefaultRemoveLinkedFolderQuery(final Shell shell) {
        return new IRemoveLinkedFolderQuery(){

            public final int doQuery(final IFolder folder) {
                final int[] result = new int[]{1};
                Display.getDefault().syncExec(new Runnable(){

                    public final void run() {
                        RemoveLinkedFolderDialog dialog = new RemoveLinkedFolderDialog(shell != null ? shell : RubyPlugin.getActiveWorkbenchShell(), folder);
                        int status = dialog.open();
                        result[0] = status == 0 ? dialog.getRemoveStatus() : 0;
                    }
                });
                return result[0];
            }
        };
    }

    public static ICreateFolderQuery getDefaultCreateFolderQuery(final Shell shell, final IRubyProject project) {
        return new ICreateFolderQuery(){
            private IFolder fNewFolder;

            public boolean doQuery() {
                final boolean[] isOK = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Shell sh = shell != null ? shell : RubyPlugin.getActiveWorkbenchShell();
                        NewFolderDialog dialog = new NewFolderDialog(sh, (IContainer)project.getProject());
                        boolean bl = isOK[0] = dialog.open() == 0;
                        if (isOK[0]) {
                            IResource sourceContainer = (IResource)dialog.getResult()[0];
                            if (sourceContainer instanceof IFolder) {
                                fNewFolder = (IFolder)sourceContainer;
                            } else {
                                fNewFolder = null;
                            }
                        }
                    }
                });
                return isOK[0];
            }

            public boolean isSourceFolder() {
                return true;
            }

            public IFolder getCreatedFolder() {
                return this.fNewFolder;
            }
        };
    }

    public static interface IAddLibrariesQuery {
        public ILoadpathEntry[] doQuery(IRubyProject var1, ILoadpathEntry[] var2);
    }

    public static interface ICreateFolderQuery {
        public boolean doQuery();

        public boolean isSourceFolder();

        public IFolder getCreatedFolder();
    }

    public static interface IInclusionExclusionQuery {
        public boolean doQuery(CPListElement var1, boolean var2);

        public IPath[] getInclusionPattern();

        public IPath[] getExclusionPattern();
    }

    public static interface ILinkToQuery {
        public boolean doQuery();

        public IFolder getCreatedFolder();
    }

    public static interface IRemoveLinkedFolderQuery {
        public static final int REMOVE_CANCEL = 0;
        public static final int REMOVE_BUILD_PATH = 1;
        public static final int REMOVE_BUILD_PATH_AND_FOLDER = 2;

        public int doQuery(IFolder var1);
    }
}

