/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.packageview.LoadPathContainer;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;

public class ConfigureBuildPathAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private IProject fProject;

    public ConfigureBuildPathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ConfigureBP_label, RubyPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ConfigureBP_tooltip);
        this.setDisabledImageDescriptor(RubyPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH);
        this.fSite = site;
    }

    private Shell getShell() {
        return this.fSite.getShell();
    }

    public void run() {
        if (this.fProject != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.fProject, (String)"org.rubypeople.rdt.ui.propertyPages.BuildPathsPropertyPage", null, null).open();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    private boolean canHandle(IStructuredSelection elements) {
        if (elements.size() != 1) {
            return false;
        }
        Object firstElement = elements.getFirstElement();
        this.fProject = this.getProjectFromSelectedElement(firstElement);
        return this.fProject != null;
    }

    private IProject getProjectFromSelectedElement(Object firstElement) {
        IResource res;
        if (firstElement instanceof IRubyElement) {
            IRubyElement element = (IRubyElement)firstElement;
            ISourceFolderRoot root = RubyModelUtil.getSourceFolderRoot(element);
            if (root != null && root != element && root.isArchive()) {
                return null;
            }
            IRubyProject project = element.getRubyProject();
            if (project != null) {
                return project.getProject();
            }
            return null;
        }
        if (firstElement instanceof LoadPathContainer) {
            return ((LoadPathContainer)firstElement).getRubyProject().getProject();
        }
        if (firstElement instanceof IAdaptable && (res = (IResource)((IAdaptable)firstElement).getAdapter(IResource.class)) != null) {
            return res.getProject();
        }
        return null;
    }
}

