/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.rubypeople.rdt.ui.wizards.ILoadpathContainerPage;
import org.rubypeople.rdt.ui.wizards.ILoadpathContainerPageExtension;
import org.rubypeople.rdt.ui.wizards.NewElementWizardPage;

public class LoadpathContainerDefaultPage
extends NewElementWizardPage
implements ILoadpathContainerPage,
ILoadpathContainerPageExtension {
    private StringDialogField fEntryField;
    private ArrayList fUsedPaths;

    public LoadpathContainerDefaultPage() {
        super("LoadpathContainerDefaultPage");
        this.setTitle(NewWizardMessages.LoadpathContainerDefaultPage_title);
        this.setDescription(NewWizardMessages.LoadpathContainerDefaultPage_description);
        this.setImageDescriptor(RubyPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fUsedPaths = new ArrayList();
        this.fEntryField = new StringDialogField();
        this.fEntryField.setLabelText(NewWizardMessages.LoadpathContainerDefaultPage_path_label);
        this.fEntryField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                LoadpathContainerDefaultPage.this.validatePath();
            }
        });
        this.validatePath();
    }

    private void validatePath() {
        StatusInfo status = new StatusInfo();
        String str = this.fEntryField.getText();
        if (str.length() == 0) {
            status.setError(NewWizardMessages.LoadpathContainerDefaultPage_path_error_enterpath);
        } else if (!Path.ROOT.isValidPath(str)) {
            status.setError(NewWizardMessages.LoadpathContainerDefaultPage_path_error_invalidpath);
        } else {
            Path path = new Path(str);
            if (path.segmentCount() == 0) {
                status.setError(NewWizardMessages.LoadpathContainerDefaultPage_path_error_needssegment);
            } else if (this.fUsedPaths.contains(path)) {
                status.setError(NewWizardMessages.LoadpathContainerDefaultPage_path_error_alreadyexists);
            }
        }
        this.updateStatus(status);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.fEntryField.doFillIntoGrid(composite, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fEntryField.getTextControl(null));
        this.fEntryField.setFocus();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.rubypeople.rdt.ui.classpath_container_default_page_context");
    }

    public boolean finish() {
        return true;
    }

    public ILoadpathEntry getSelection() {
        return RubyCore.newContainerEntry((IPath)new Path(this.fEntryField.getText()));
    }

    public void initialize(IRubyProject project, ILoadpathEntry[] currentEntries) {
        int i = 0;
        while (i < currentEntries.length) {
            ILoadpathEntry curr = currentEntries[i];
            if (curr.getEntryKind() == 5) {
                this.fUsedPaths.add(curr.getPath());
            }
            ++i;
        }
    }

    public void setSelection(ILoadpathEntry containerEntry) {
        if (containerEntry != null) {
            this.fUsedPaths.remove(containerEntry.getPath());
            this.fEntryField.setText(containerEntry.getPath().toString());
        } else {
            this.fEntryField.setText("");
        }
    }
}

