/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;

public class CPUserLibraryElement {
    private String fName;
    private List fChildren;
    private boolean fIsSystemLibrary;

    public CPUserLibraryElement(String name, ILoadpathContainer container, IRubyProject project) {
        this.fName = name;
        this.fChildren = new ArrayList();
        if (container != null) {
            ILoadpathEntry[] entries = container.getLoadpathEntries();
            CPListElement[] res = new CPListElement[entries.length];
            int i = 0;
            while (i < res.length) {
                ILoadpathEntry curr = entries[i];
                CPListElement elem = CPListElement.createFromExisting(this, curr, project);
                this.fChildren.add(elem);
                ++i;
            }
            this.fIsSystemLibrary = container.getKind() == 2;
        } else {
            this.fIsSystemLibrary = false;
        }
    }

    public CPUserLibraryElement(String name, boolean isSystemLibrary, CPListElement[] children) {
        this.fName = name;
        this.fChildren = new ArrayList();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.fChildren.add(children[i]);
                ++i;
            }
        }
        this.fIsSystemLibrary = isSystemLibrary;
    }

    public CPListElement[] getChildren() {
        return this.fChildren.toArray(new CPListElement[this.fChildren.size()]);
    }

    public String getName() {
        return this.fName;
    }

    public IPath getPath() {
        return new Path("org.rubypeople.rdt.USER_LIBRARY").append(this.fName);
    }

    public boolean isSystemLibrary() {
        return this.fIsSystemLibrary;
    }

    public void add(CPListElement element) {
        if (!this.fChildren.contains(element)) {
            this.fChildren.add(element);
        }
    }

    private List moveUp(List elements, List move) {
        int nElements = elements.size();
        ArrayList res = new ArrayList(nElements);
        Object floating = null;
        int i = 0;
        while (i < nElements) {
            Object curr = elements.get(i);
            if (move.contains(curr)) {
                res.add(curr);
            } else {
                if (floating != null) {
                    res.add(floating);
                }
                floating = curr;
            }
            ++i;
        }
        if (floating != null) {
            res.add(floating);
        }
        return res;
    }

    public void moveUp(List toMoveUp) {
        if (toMoveUp.size() > 0) {
            this.fChildren = this.moveUp(this.fChildren, toMoveUp);
        }
    }

    public void moveDown(List toMoveDown) {
        if (toMoveDown.size() > 0) {
            Collections.reverse(this.fChildren);
            this.fChildren = this.moveUp(this.fChildren, toMoveDown);
            Collections.reverse(this.fChildren);
        }
    }

    public void remove(CPListElement element) {
        this.fChildren.remove(element);
    }

    public void replace(CPListElement existingElement, CPListElement element) {
        if (this.fChildren.contains(element)) {
            this.fChildren.remove(existingElement);
        } else {
            int index = this.fChildren.indexOf(existingElement);
            if (index != -1) {
                this.fChildren.set(index, element);
            } else {
                this.fChildren.add(element);
            }
        }
    }

    private void copyAttribute(CPListElement source, CPListElement target, String attributeName) {
        Object value = source.getAttribute(attributeName);
        if (value != null) {
            target.setAttribute(attributeName, value);
        }
    }

    public ILoadpathContainer getUpdatedContainer() {
        return new UpdatedLoadpathContainer();
    }

    public boolean hasChanges(ILoadpathContainer oldContainer) {
        if (oldContainer == null || oldContainer.getKind() == 2 != this.fIsSystemLibrary) {
            return true;
        }
        ILoadpathEntry[] oldEntries = oldContainer.getLoadpathEntries();
        if (this.fChildren.size() != oldEntries.length) {
            return true;
        }
        int i = 0;
        while (i < oldEntries.length) {
            CPListElement child = (CPListElement)this.fChildren.get(i);
            if (!child.getLoadpathEntry().equals(oldEntries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class UpdatedLoadpathContainer
    implements ILoadpathContainer {
        private UpdatedLoadpathContainer() {
        }

        public ILoadpathEntry[] getLoadpathEntries() {
            CPListElement[] children = CPUserLibraryElement.this.getChildren();
            ILoadpathEntry[] entries = new ILoadpathEntry[children.length];
            int i = 0;
            while (i < entries.length) {
                entries[i] = children[i].getLoadpathEntry();
                ++i;
            }
            return entries;
        }

        public String getDescription() {
            return CPUserLibraryElement.this.getName();
        }

        public int getKind() {
            return CPUserLibraryElement.this.isSystemLibrary() ? 2 : 1;
        }

        public IPath getPath() {
            return CPUserLibraryElement.this.getPath();
        }
    }
}

