/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.ui.RubyInstalledDetector;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.wizards.BrowseToInstalledRubyWizardPage;
import org.rubypeople.rdt.internal.ui.wizards.InstallRubyWizardPage;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.UseJRubyWizardPage;

public class InstallStandardRubyWizard
extends Wizard
implements INewWizard {
    private static final String WINDOWS_INSTALL_URL = "http://www.aptana.com/ruby/install/windows";
    private static final String LINUX_INSTALL_URL = "http://www.aptana.com/ruby/install/linux";
    private static final String MACOSX_INSTALL_URL = "http://www.aptana.com/ruby/install/macosx";
    private static final String RUBY_BROWSER_ID = String.valueOf(RubyPlugin.getPluginId()) + ".ruby.download.browser";

    public InstallStandardRubyWizard() {
        this.setWindowTitle(NewWizardMessages.InstallStandardRubyWizard_TTL_Window);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage(new InstallRubyWizardPage());
    }

    public boolean performFinish() {
        Preferences store;
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page instanceof InstallRubyWizardPage && ((InstallRubyWizardPage)page).downloadSelected()) {
            this.openBrowser(this.getURL());
        } else if (page instanceof BrowseToInstalledRubyWizardPage) {
            ((BrowseToInstalledRubyWizardPage)page).addVM();
        } else if (page instanceof UseJRubyWizardPage && (store = LaunchingPlugin.getDefault().getPluginPreferences()) != null) {
            store.setValue("org.rubypeople.rdt.launching.us.included.jruby", true);
        }
        return true;
    }

    public void dispose() {
        RubyInstalledDetector.markFinished();
        super.dispose();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private String getURL() {
        if (Platform.getOS().equals("win32")) {
            return WINDOWS_INSTALL_URL;
        }
        if (Platform.getOS().equals("macosx")) {
            return MACOSX_INSTALL_URL;
        }
        return LINUX_INSTALL_URL;
    }

    private void openBrowser(String url) {
        try {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = support.createBrowser(RUBY_BROWSER_ID);
            browser.openURL(new URL(url));
        }
        catch (PartInitException e) {
            RubyPlugin.log(e);
        }
        catch (MalformedURLException e) {
            RubyPlugin.log(e);
        }
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }
}

