/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.rubypeople.rdt.launching.VMStandin;

class BrowseToInstalledRubyWizardPage
extends WizardPage
implements IWizardPage,
IPageChangedListener {
    private Button fBrowseButton;
    private Text fText;
    private String defaultValue;

    protected BrowseToInstalledRubyWizardPage() {
        this(null);
    }

    protected BrowseToInstalledRubyWizardPage(String defaultValue) {
        super("");
        this.setTitle(NewWizardMessages.BrowseToInstalledRubyWizardPage_TTL);
        this.setDescription(NewWizardMessages.BrowseToInstalledRubyWizardPage_MSG_Description);
        this.defaultValue = defaultValue;
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(main, 64);
        label.setText(NewWizardMessages.BrowseToInstalledRubyWizardPage_MSG_Explanation_text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = parent.getSize().x;
        label.setLayoutData((Object)data);
        this.fText = new Text(main, 2052);
        GridData textData = new GridData();
        textData.widthHint = 400;
        this.fText.setLayoutData((Object)textData);
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BrowseToInstalledRubyWizardPage.this.validateVMLocation();
            }
        });
        this.fBrowseButton = new Button(main, 16392);
        this.fBrowseButton.setText(NewWizardMessages.BrowseToInstalledRubyWizardPage_LBL_Browse_button);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(BrowseToInstalledRubyWizardPage.this.getShell());
                dialog.setFilterPath(BrowseToInstalledRubyWizardPage.this.fText.getText());
                dialog.setMessage(NewWizardMessages.BrowseToInstalledRubyWizardPage_MSG_Browse_dialog);
                String newPath = dialog.open();
                BrowseToInstalledRubyWizardPage.this.fText.setText(newPath);
                BrowseToInstalledRubyWizardPage.this.validateVMLocation();
                super.widgetSelected(e);
            }
        });
        this.setControl((Control)main);
        ((WizardPage)this.getWizard().getStartingPage()).setPageComplete(false);
        this.getWizardDialog().addPageChangedListener((IPageChangedListener)this);
        if (this.defaultValue != null) {
            this.fText.setText(this.defaultValue);
            this.validateVMLocation();
        }
    }

    protected void validateVMLocation() {
        final IVMInstallType type = this.getStandardVMType();
        if (type == null) {
            this.setErrorMessage(NewWizardMessages.BrowseToInstalledRubyWizardPage_ERR_MSG_Unable_find_standard_vm_metadata);
            ((WizardPage)this.getWizard().getStartingPage()).setPageComplete(false);
            this.getContainer().updateButtons();
            return;
        }
        String location = this.fText.getText();
        if (location == null || location.trim().length() == 0) {
            this.setErrorMessage(NewWizardMessages.BrowseToInstalledRubyWizardPage_ERR_MSG_Location_empty);
            ((WizardPage)this.getWizard().getStartingPage()).setPageComplete(false);
            this.getContainer().updateButtons();
            return;
        }
        final IStatus[] temp = new IStatus[1];
        final File tempFile = new File(location);
        Runnable r = new Runnable(){

            public void run() {
                temp[0] = type.validateInstallLocation(tempFile);
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
        if (temp[0].getSeverity() == 4) {
            this.setErrorMessage(temp[0].getMessage());
            ((WizardPage)this.getWizard().getStartingPage()).setPageComplete(false);
            this.getContainer().updateButtons();
        } else if (temp[0].getSeverity() == 2) {
            this.setMessage(temp[0].getMessage(), 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
            ((WizardPage)this.getWizard().getStartingPage()).setPageComplete(true);
            this.getContainer().updateButtons();
        }
    }

    private IVMInstallType getStandardVMType() {
        return RubyRuntime.getVMInstallType((String)"org.rubypeople.rdt.launching.StandardVMType");
    }

    public void addVM() {
        VMStandin standin = new VMStandin(this.getStandardVMType(), String.valueOf(System.currentTimeMillis()));
        standin.setName(NewWizardMessages.BrowseToInstalledRubyWizardPage_LBL_Standard_ruby_entry_name);
        standin.setInstallLocation(new File(this.fText.getText()));
        IVMInstall vm = standin.convertToRealVM();
        try {
            RubyRuntime.setDefaultVMInstall((IVMInstall)vm, (IProgressMonitor)new NullProgressMonitor(), (boolean)true);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private WizardDialog getWizardDialog() {
        return (WizardDialog)this.getContainer();
    }

    public void dispose() {
        if (this.getWizardDialog() != null) {
            this.getWizardDialog().removePageChangedListener((IPageChangedListener)this);
        }
        super.dispose();
    }

    public void pageChanged(PageChangedEvent event) {
        Object page = event.getSelectedPage();
        if (page.equals((Object)this)) {
            this.validateVMLocation();
        }
    }
}

