/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.rubypeople.rdt.core.Flags;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.ERBScript;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.ui.RubyElementImageDescriptor;
import org.rubypeople.rdt.ui.viewsupport.ImageDescriptorRegistry;

public class RubyElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private ImageDescriptorRegistry fRegistry;

    public RubyElementImageProvider() {
        ISharedImages images = RubyPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
        this.fRegistry = null;
    }

    public Image getImageLabel(Object element, int flags) {
        return this.getImageLabel(this.computeDescriptor(element, flags));
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = RubyPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private ImageDescriptor computeDescriptor(Object element, int flags) {
        if (element instanceof IRubyElement) {
            return this.getRubyImageDescriptor((IRubyElement)element, flags);
        }
        if (element instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if (RubyCore.isRubyLikeFileName((String)file.getName())) {
                return this.getCUResourceImageDescriptor(file, flags);
            }
            return this.getWorkbenchImageDescriptor((IAdaptable)file, flags);
        }
        return null;
    }

    private static boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    private static boolean useLightIcons(int flags) {
        return (flags & 4) != 0;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile file, int flags) {
        Point size = RubyElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new RubyElementImageDescriptor(RubyPluginImages.DESC_OBJS_RUBY_RESOURCE, 0, size);
    }

    public ImageDescriptor getRubyImageDescriptor(IRubyElement element, int flags) {
        int adornmentFlags = this.computeRubyAdornmentFlags(element, flags);
        Point size = RubyElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new RubyElementImageDescriptor(this.getBaseImageDescriptor(element, flags), adornmentFlags, size);
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        Point size = RubyElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new RubyElementImageDescriptor(descriptor, 0, size);
    }

    public ImageDescriptor getBaseImageDescriptor(IRubyElement element, int renderFlags) {
        try {
            switch (element.getElementType()) {
                case 6: {
                    IMethod method = (IMethod)element;
                    method.getDeclaringType();
                    int flags = method.getVisibility();
                    return RubyElementImageProvider.getMethodImageDescriptor(flags);
                }
                case 7: {
                    return RubyPluginImages.DESC_OBJS_GLOBAL;
                }
                case 10: {
                    return RubyPluginImages.DESC_OBJS_CLASS_VAR;
                }
                case 9: {
                    return RubyPluginImages.DESC_OBJS_CONSTANT;
                }
                case 12: 
                case 14: {
                    return RubyPluginImages.DESC_OBJS_LOCAL_VAR;
                }
                case 11: {
                    return RubyPluginImages.DESC_OBJS_INSTANCE_VAR;
                }
                case 8: {
                    return RubyPluginImages.DESC_OBJS_IMPDECL;
                }
                case 16: {
                    return RubyPluginImages.DESC_OBJS_IMPCONT;
                }
                case 13: {
                    return RubyPluginImages.DESC_OBJS_BLOCK;
                }
                case 5: {
                    IType type = (IType)element;
                    IType declType = type.getDeclaringType();
                    boolean isInner = declType != null;
                    return RubyElementImageProvider.getTypeImageDescriptor(type.isModule(), isInner, RubyElementImageProvider.useLightIcons(renderFlags));
                }
                case 4: {
                    if (element instanceof ERBScript) {
                        return RubyPluginImages.DESC_OBJS_ERB_SCRIPT;
                    }
                    return RubyPluginImages.DESC_OBJS_SCRIPT;
                }
                case 3: {
                    return RubyPluginImages.DESC_OBJS_SOURCE_FOLDER;
                }
                case 2: {
                    ISourceFolderRoot root = (ISourceFolderRoot)element;
                    if (root.isExternal()) {
                        return RubyPluginImages.DESC_OBJS_LIBRARY;
                    }
                    return RubyPluginImages.DESC_OBJS_SOURCE_FOLDER_ROOT;
                }
                case 1: {
                    IRubyProject jp = (IRubyProject)element;
                    if (jp.getProject().isOpen()) {
                        ImageDescriptor result;
                        IProject project = jp.getProject();
                        IWorkbenchAdapter adapter = (IWorkbenchAdapter)project.getAdapter(IWorkbenchAdapter.class);
                        if (adapter != null && (result = adapter.getImageDescriptor((Object)project)) != null) {
                            return result;
                        }
                        return DESC_OBJ_PROJECT;
                    }
                    return DESC_OBJ_PROJECT_CLOSED;
                }
                case 0: {
                    return RubyPluginImages.DESC_OBJS_RUBY_MODEL;
                }
            }
            Assert.isTrue((boolean)false, (String)RubyUIMessages.RubyImageLabelprovider_assert_wrongImage);
            return RubyPluginImages.DESC_OBJS_GHOST;
        }
        catch (RubyModelException rubyModelException) {
            return RubyPluginImages.DESC_OBJS_UNKNOWN;
        }
    }

    public void dispose() {
    }

    private int computeRubyAdornmentFlags(IRubyElement element, int renderFlags) {
        int flags = 0;
        if (RubyElementImageProvider.showOverlayIcons(renderFlags) && element instanceof IMember) {
            IMember cfr_ignored_0 = (IMember)element;
            if (element.getElementType() == 6 && ((IMethod)element).isConstructor()) {
                flags |= 0x200;
            }
            if (element.getElementType() == 6 && ((IMethod)element).isSingleton()) {
                flags |= 8;
            }
        }
        return flags;
    }

    public static ImageDescriptor getMethodImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags)) {
            return RubyPluginImages.DESC_MISC_PUBLIC;
        }
        if (Flags.isProtected((int)flags)) {
            return RubyPluginImages.DESC_MISC_PROTECTED;
        }
        return RubyPluginImages.DESC_MISC_PRIVATE;
    }

    public static ImageDescriptor getTypeImageDescriptor(boolean isModule, boolean isInner, boolean useLightIcons) {
        if (isModule) {
            if (useLightIcons) {
                return RubyPluginImages.DESC_OBJS_MODULEALT;
            }
            if (isInner) {
                return RubyElementImageProvider.getInnerModuleImageDescriptor();
            }
            return RubyPluginImages.DESC_OBJS_MODULE;
        }
        if (useLightIcons) {
            return RubyPluginImages.DESC_OBJS_CLASSALT;
        }
        if (isInner) {
            return RubyElementImageProvider.getInnerClassImageDescriptor();
        }
        return RubyElementImageProvider.getClassImageDescriptor();
    }

    public static Image getDecoratedImage(ImageDescriptor baseImage, int adornments, Point size) {
        return RubyPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new RubyElementImageDescriptor(baseImage, adornments, size));
    }

    private static ImageDescriptor getClassImageDescriptor() {
        return RubyPluginImages.DESC_OBJS_CLASS;
    }

    private static ImageDescriptor getInnerClassImageDescriptor() {
        return RubyPluginImages.DESC_OBJS_INNER_CLASS;
    }

    private static ImageDescriptor getInnerModuleImageDescriptor() {
        return RubyPluginImages.DESC_OBJS_MODULE;
    }

    public static ImageDescriptor getConstantImageDescriptor() {
        return RubyPluginImages.DESC_OBJS_CONSTANT;
    }

    public static ImageDescriptor getClassVariableImageDescriptor() {
        return RubyPluginImages.DESC_OBJS_CLASS_VAR;
    }

    public static ImageDescriptor getInstanceVariableImageDescriptor() {
        return RubyPluginImages.DESC_OBJS_INSTANCE_VAR;
    }

    public static ImageDescriptor getGlobalVariableImageDescriptor() {
        return RubyPluginImages.DESC_OBJS_GLOBAL;
    }
}

