/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.viewsupport;

import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.rubypeople.rdt.internal.ui.viewsupport.ColoredString;

public abstract class OwnerDrawSupport
implements Listener {
    private TextLayout fTextLayout;
    private final Control fControl;

    public OwnerDrawSupport(Control control) {
        this.fControl = control;
        this.fTextLayout = new TextLayout((Device)control.getDisplay());
        control.addListener(42, (Listener)this);
        control.addListener(40, (Listener)this);
        control.addListener(12, (Listener)this);
    }

    public abstract ColoredString getColoredLabel(Item var1);

    public abstract Color getColor(String var1, Display var2);

    public void handleEvent(Event event) {
        if (event.type == 42) {
            this.performPaint(event);
        } else if (event.type == 40) {
            this.performErase(event);
        } else if (event.type == 12) {
            this.dispose();
        }
    }

    private void performErase(Event event) {
        event.detail &= 0xFFFFFFEF;
    }

    private void performPaint(Event event) {
        boolean isSelected;
        Item item = (Item)event.item;
        GC gc = event.gc;
        ColoredString coloredLabel = this.getColoredLabel(item);
        boolean bl = isSelected = (event.detail & 2) != 0 && this.fControl.isFocusControl();
        if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            Image image = treeItem.getImage(event.index);
            if (image != null) {
                this.processImage(image, gc, treeItem.getImageBounds(event.index));
            }
            Rectangle textBounds = treeItem.getBounds(event.index);
            Font font = treeItem.getFont(event.index);
            this.processColoredLabel(coloredLabel, gc, textBounds, isSelected, font);
            Rectangle bounds = treeItem.getBounds();
            if ((event.detail & 4) != 0) {
                gc.drawFocus(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        } else if (item instanceof TableItem) {
            TableItem tableItem = (TableItem)item;
            Image image = tableItem.getImage(event.index);
            if (image != null) {
                this.processImage(image, gc, tableItem.getImageBounds(event.index));
            }
            Rectangle textBounds = tableItem.getBounds(event.index);
            Font font = tableItem.getFont(event.index);
            this.processColoredLabel(coloredLabel, gc, textBounds, isSelected, font);
            Rectangle bounds = tableItem.getBounds();
            if ((event.detail & 4) != 0) {
                gc.drawFocus(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
    }

    private void processImage(Image image, GC gc, Rectangle imageBounds) {
        Rectangle bounds = image.getBounds();
        int x = imageBounds.x + Math.max(0, (imageBounds.width - bounds.width) / 2);
        int y = imageBounds.y + Math.max(0, (imageBounds.height - bounds.height) / 2);
        gc.drawImage(image, x, y);
    }

    private void processColoredLabel(ColoredString richLabel, GC gc, Rectangle textBounds, boolean isSelected, Font font) {
        String text = richLabel.getString();
        this.fTextLayout.setText(text);
        this.fTextLayout.setFont(font);
        if (!isSelected) {
            Display display = (Display)gc.getDevice();
            Iterator ranges = richLabel.getRanges();
            while (ranges.hasNext()) {
                ColoredString.StyleRange curr = (ColoredString.StyleRange)ranges.next();
                ColoredString.Style style = curr.style;
                if (style == null) continue;
                Color foreground = this.getColor(style.getForegroundColorName(), display);
                TextStyle textStyle = new TextStyle(null, foreground, null);
                this.fTextLayout.setStyle(textStyle, curr.offset, curr.offset + curr.length - 1);
            }
        }
        Rectangle bounds = this.fTextLayout.getBounds();
        int x = textBounds.x;
        int y = textBounds.y + Math.max(0, (textBounds.height - bounds.height) / 2);
        this.fTextLayout.draw(gc, x, y);
        this.fTextLayout.setText("");
    }

    public void dispose() {
        if (this.fTextLayout != null) {
            this.fTextLayout.dispose();
            this.fTextLayout = null;
        }
        if (!this.fControl.isDisposed()) {
            this.fControl.removeListener(42, (Listener)this);
            this.fControl.removeListener(40, (Listener)this);
            this.fControl.removeListener(12, (Listener)this);
        }
    }
}

