/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.viewsupport;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.rubypeople.rdt.core.Flags;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.RubyModelException;

public class MemberFilter
extends ViewerFilter {
    public static final int FILTER_NONPUBLIC = 1;
    public static final int FILTER_STATIC = 2;
    public static final int FILTER_FIELDS = 4;
    public static final int FILTER_LOCALTYPES = 8;
    private int fFilterProperties;

    public final void addFilter(int filter) {
        this.fFilterProperties |= filter;
    }

    public final void removeFilter(int filter) {
        this.fFilterProperties &= 0xFFFFFFFF ^ filter;
    }

    public final boolean hasFilter(int filter) {
        return (this.fFilterProperties & filter) != 0;
    }

    public boolean isFilterProperty(Object element, Object property) {
        return false;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            int memberType = member.getElementType();
            if (this.hasFilter(4) && (memberType == 10 || memberType == 9 || memberType == 11 || memberType == 12)) {
                return false;
            }
            if (member.isType(6)) {
                IMethod method = (IMethod)member;
                try {
                    if (this.hasFilter(1) && !Flags.isPublic((int)method.getVisibility())) {
                        return false;
                    }
                }
                catch (RubyModelException rubyModelException) {
                    return true;
                }
                if (this.hasFilter(2) && method.isSingleton()) {
                    return false;
                }
            }
            if (this.hasFilter(8) && (memberType == 12 || memberType == 14)) {
                return false;
            }
        }
        return true;
    }
}

