/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.ElementListSelectionDialog;
import org.rubypeople.rdt.internal.ui.util.ResourceSelector;

public class RubyProjectSelector
extends ResourceSelector {
    public RubyProjectSelector(Composite parent) {
        super(parent);
        this.browseDialogTitle = "Project Selection";
    }

    public IProject getSelection() {
        String projectName = this.getSelectionText();
        if (projectName != null && !projectName.equals("")) {
            return RubyPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    protected void handleBrowseSelected() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setTitle(this.browseDialogTitle);
        dialog.setMessage(this.browseDialogMessage);
        dialog.setElements(RubyCore.getRubyProjects());
        if (dialog.open() == 0) {
            this.textField.setText(((IProject)dialog.getFirstResult()).getName());
        }
    }

    protected String validateResourceSelection() {
        IProject project = this.getSelection();
        return project == null ? "" : project.getName();
    }
}

