/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.util;

import java.io.File;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.rubypeople.rdt.internal.ui.util.ResourceSelector;

public class FileSelector
extends ResourceSelector {
    public FileSelector(Composite parent) {
        super(parent);
    }

    protected void handleBrowseSelected() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(this.browseDialogMessage);
        this.setFilterPath(dialog);
        String selectedFile = dialog.open();
        if (selectedFile != null) {
            this.setText(selectedFile);
        }
    }

    protected void setText(String selectedFile) {
        this.textField.setText(selectedFile);
    }

    protected boolean setFilterPath(FileDialog dialog) {
        File path;
        String currentWorkingDir = this.textField.getText();
        if (!currentWorkingDir.trim().equals("") && (path = new File(currentWorkingDir)).exists()) {
            dialog.setFilterPath(currentWorkingDir);
            return true;
        }
        return false;
    }

    protected String validateResourceSelection() {
        String file = this.textField.getText();
        File directoryFile = new File(file);
        if (directoryFile.exists() && directoryFile.isFile()) {
            return file;
        }
        return "";
    }

    public File getSelection() {
        return new File(this.getSelectionText());
    }
}

