/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.typehierarchy;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.MethodOverrideTester;
import org.rubypeople.rdt.internal.ui.typehierarchy.MethodsViewer;
import org.rubypeople.rdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.rubypeople.rdt.ui.RubyElementLabels;

public class MethodsLabelProvider
extends AppearanceAwareLabelProvider {
    private Color fResolvedBackground;
    private boolean fShowDefiningType;
    private TypeHierarchyLifeCycle fHierarchy;
    private MethodsViewer fMethodsViewer;

    public MethodsLabelProvider(TypeHierarchyLifeCycle lifeCycle, MethodsViewer methodsViewer) {
        super(0x210000000002L, 1);
        this.fHierarchy = lifeCycle;
        this.fShowDefiningType = false;
        this.fMethodsViewer = methodsViewer;
        this.fResolvedBackground = null;
    }

    public void setShowDefiningType(boolean showDefiningType) {
        this.fShowDefiningType = showDefiningType;
    }

    public boolean isShowDefiningType() {
        return this.fShowDefiningType;
    }

    private IType getDefiningType(Object element) throws RubyModelException {
        int kind = ((IRubyElement)element).getElementType();
        if (kind != 6 && kind != 15 && kind != 9 && kind != 11 && kind != 10) {
            return null;
        }
        IType declaringType = ((IMember)element).getDeclaringType();
        if (kind != 6) {
            return declaringType;
        }
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return declaringType;
        }
        MethodOverrideTester tester = new MethodOverrideTester(declaringType, hierarchy);
        IMethod method = (IMethod)element;
        IMethod res = tester.findDeclaringMethod(method, true);
        if (res == null || method.equals(res)) {
            return declaringType;
        }
        return res.getDeclaringType();
    }

    public String getText(Object element) {
        String text = super.getText(element);
        if (this.fShowDefiningType) {
            try {
                IType type = this.getDefiningType(element);
                if (type != null) {
                    StringBuffer buf = new StringBuffer(super.getText(type));
                    buf.append(RubyElementLabels.CONCAT_STRING);
                    buf.append(text);
                    return buf.toString();
                }
            }
            catch (RubyModelException rubyModelException) {}
        }
        return text;
    }

    public Color getForeground(Object element) {
        IMethod curr;
        IType declaringType;
        if (this.fMethodsViewer.isShowInheritedMethods() && element instanceof IMethod && (declaringType = (curr = (IMethod)element).getDeclaringType()).equals(this.fMethodsViewer.getInput())) {
            if (this.fResolvedBackground == null) {
                Display display = Display.getCurrent();
                this.fResolvedBackground = display.getSystemColor(10);
            }
            return this.fResolvedBackground;
        }
        return null;
    }
}

